/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;

class JsonFormatter
extends Formatter {
    public static final Json JSON = new Json();

    JsonFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        TreeMap<String, Object> logRecord = new TreeMap<String, Object>();
        Instant instant = Instant.ofEpochMilli(record.getMillis());
        ZonedDateTime local = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        logRecord.put("log-time-local", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(local));
        logRecord.put("log-time-utc", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(local.withZoneSameInstant(ZoneOffset.UTC)));
        String[] split = record.getSourceClassName().split("\\.");
        logRecord.put("class", split[split.length - 1]);
        logRecord.put("method", record.getSourceMethodName());
        logRecord.put("log-name", record.getLoggerName());
        logRecord.put("log-level", record.getLevel());
        logRecord.put("log-message", record.getMessage());
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = JSON.newOutput(text).setPrettyPrint(false);){
            json.write(logRecord);
            text.append('\n');
        }
        return text.toString();
    }
}

