/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.PublicApi;
import java.util.function.Consumer;

@PublicApi
public class ParserOptions {
    public static int MAX_QUERY_TOKENS = 15000;
    private static ParserOptions defaultJvmParserOptions = ParserOptions.newParserOptions().captureIgnoredChars(false).captureSourceLocation(true).maxTokens(MAX_QUERY_TOKENS).build();
    private final boolean captureIgnoredChars;
    private final boolean captureSourceLocation;
    private final int maxTokens;

    public static ParserOptions getDefaultParserOptions() {
        return defaultJvmParserOptions;
    }

    public static void setDefaultParserOptions(ParserOptions options) {
        defaultJvmParserOptions = Assert.assertNotNull(options);
    }

    private ParserOptions(Builder builder) {
        this.captureIgnoredChars = builder.captureIgnoredChars;
        this.captureSourceLocation = builder.captureSourceLocation;
        this.maxTokens = builder.maxTokens;
    }

    public boolean isCaptureIgnoredChars() {
        return this.captureIgnoredChars;
    }

    public boolean isCaptureSourceLocation() {
        return this.captureSourceLocation;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public ParserOptions transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newParserOptions() {
        return new Builder();
    }

    public static class Builder {
        private boolean captureIgnoredChars = false;
        private boolean captureSourceLocation = true;
        private int maxTokens = MAX_QUERY_TOKENS;

        Builder() {
        }

        Builder(ParserOptions parserOptions) {
            this.captureIgnoredChars = parserOptions.captureIgnoredChars;
            this.captureSourceLocation = parserOptions.captureSourceLocation;
            this.maxTokens = parserOptions.maxTokens;
        }

        public Builder captureIgnoredChars(boolean captureIgnoredChars) {
            this.captureIgnoredChars = captureIgnoredChars;
            return this;
        }

        public Builder captureSourceLocation(boolean captureSourceLocation) {
            this.captureSourceLocation = captureSourceLocation;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ParserOptions build() {
            return new ParserOptions(this);
        }
    }
}

