/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.Config;
import zmq.Ctx;
import zmq.Mailbox;
import zmq.Msg;
import zmq.Own;
import zmq.ZMQ;
import zmq.ZObject;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.net.Address;
import zmq.io.net.NetProtocol;
import zmq.io.net.ipc.IpcListener;
import zmq.io.net.tcp.TcpAddress;
import zmq.io.net.tcp.TcpListener;
import zmq.io.net.tipc.TipcListener;
import zmq.pipe.Pipe;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;
import zmq.socket.Sockets;
import zmq.util.Blob;
import zmq.util.Clock;
import zmq.util.MultiMap;

public abstract class SocketBase
extends Own
implements IPollEvents,
Pipe.IPipeEvents {
    private final MultiMap<String, EndpointPipe> endpoints;
    private final MultiMap<String, Pipe> inprocs;
    private boolean active = true;
    private boolean ctxTerminated = false;
    private boolean destroyed = false;
    private final Mailbox mailbox;
    private final Set<Pipe> pipes;
    private Poller poller;
    private Poller.Handle handle;
    private long lastTsc = 0L;
    private int ticks = 0;
    private boolean rcvmore = false;
    private SocketChannel fileDesc;
    private SocketBase monitorSocket = null;
    private int monitorEvents = 0;
    protected String connectRid;
    private final ReentrantLock monitorSync = new ReentrantLock(false);

    protected SocketBase(Ctx parent, int tid, int sid) {
        super(parent, tid);
        this.options.socketId = sid;
        this.options.ipv6 = parent.get(42) != 0;
        this.options.linger = parent.get(70) != 0 ? -1 : 0;
        this.endpoints = new MultiMap();
        this.inprocs = new MultiMap();
        this.pipes = new HashSet<Pipe>();
        this.mailbox = new Mailbox(parent, "socket-" + sid, tid);
    }

    protected abstract void xattachPipe(Pipe var1, boolean var2, boolean var3);

    protected abstract void xpipeTerminated(Pipe var1);

    boolean isActive() {
        return this.active;
    }

    @Override
    protected void destroy() {
        try {
            this.monitorSync.lock();
            try {
                this.mailbox.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopMonitor();
            assert (this.destroyed);
        }
        finally {
            this.monitorSync.unlock();
        }
    }

    final Mailbox getMailbox() {
        return this.mailbox;
    }

    final void stop() {
        this.sendStop();
    }

    private NetProtocol checkProtocol(String protocol) {
        NetProtocol proto = NetProtocol.getProtocol(protocol);
        if (proto == null || !proto.valid) {
            this.errno.set(43);
            return proto;
        }
        if (!proto.compatible(this.options.type)) {
            this.errno.set(156384764);
            return null;
        }
        return proto;
    }

    private void attachPipe(Pipe pipe, boolean isLocallyInitiated) {
        this.attachPipe(pipe, false, isLocallyInitiated);
    }

    private void attachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        pipe.setEventSink(this);
        this.pipes.add(pipe);
        this.xattachPipe(pipe, subscribe2all, isLocallyInitiated);
        if (this.isTerminating()) {
            this.registerTermAcks(1);
            pipe.terminate(false);
        }
    }

    public final boolean setSocketOpt(int option, Object optval) {
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return false;
        }
        boolean rc = this.xsetsockopt(option, optval);
        if (rc || this.errno.get() != 22) {
            return rc;
        }
        rc = this.options.setSocketOpt(option, optval);
        if (rc) {
            this.errno.set(0);
        }
        return rc;
    }

    public final int getSocketOpt(int option) {
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return -1;
        }
        if (option == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option == 15) {
            boolean rc = this.processCommands(0, false);
            if (!(rc || this.errno.get() != 156384765 && this.errno.get() != 4)) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.hasOut()) {
                val |= 2;
            }
            if (this.hasIn()) {
                val |= 1;
            }
            return val;
        }
        Object val = this.options.getSocketOpt(option);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        throw new IllegalArgumentException(val + " is neither an integer or a boolean for option " + option);
    }

    public final Object getSocketOptx(int option) {
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return null;
        }
        if (option == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option == 14) {
            return this.mailbox.getFd();
        }
        if (option == 15) {
            boolean rc = this.processCommands(0, false);
            if (!(rc || this.errno.get() != 156384765 && this.errno.get() != 4)) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.hasOut()) {
                val |= 2;
            }
            if (this.hasIn()) {
                val |= 1;
            }
            return val;
        }
        return this.options.getSocketOpt(option);
    }

    public final boolean bind(String addr) {
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return false;
        }
        this.options.mechanism.check(this.options);
        boolean brc = this.processCommands(0, false);
        if (!brc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String protocolName = uri.getProtocol();
        String address = uri.getAddress();
        NetProtocol protocol = this.checkProtocol(protocolName);
        if (protocol == null || !protocol.valid) {
            return false;
        }
        if (NetProtocol.inproc.equals((Object)protocol)) {
            Ctx.Endpoint endpoint = new Ctx.Endpoint(this, this.options);
            boolean rc = this.registerEndpoint(addr, endpoint);
            if (rc) {
                this.connectPending(addr, this);
                this.options.lastEndpoint = addr;
            } else {
                this.errno.set(48);
            }
            return rc;
        }
        if (NetProtocol.pgm.equals((Object)protocol) || NetProtocol.epgm.equals((Object)protocol) || NetProtocol.norm.equals((Object)protocol)) {
            return this.connect(addr);
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        if (ioThread == null) {
            this.errno.set(156384766);
            return false;
        }
        if (NetProtocol.tcp.equals((Object)protocol)) {
            TcpListener listener = new TcpListener(ioThread, this, this.options);
            boolean rc = listener.setAddress(address);
            if (!rc) {
                listener.destroy();
                this.eventBindFailed(address, this.errno.get());
                return false;
            }
            this.options.lastEndpoint = listener.getAddress();
            this.addEndpoint(this.options.lastEndpoint, listener, null);
            return true;
        }
        if (NetProtocol.ipc.equals((Object)protocol)) {
            IpcListener listener = new IpcListener(ioThread, this, this.options);
            boolean rc = listener.setAddress(address);
            if (!rc) {
                listener.destroy();
                this.eventBindFailed(address, this.errno.get());
                return false;
            }
            this.options.lastEndpoint = listener.getAddress();
            this.addEndpoint(this.options.lastEndpoint, listener, null);
            return true;
        }
        if (NetProtocol.tipc.equals((Object)protocol)) {
            TipcListener listener = new TipcListener(ioThread, this, this.options);
            boolean rc = listener.setAddress(address);
            if (!rc) {
                listener.destroy();
                this.eventBindFailed(address, this.errno.get());
                return false;
            }
            this.options.lastEndpoint = listener.getAddress();
            this.addEndpoint(addr, listener, null);
            return true;
        }
        throw new IllegalArgumentException(addr);
    }

    public final boolean connect(String addr) {
        boolean isSingleConnect;
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return false;
        }
        this.options.mechanism.check(this.options);
        boolean brc = this.processCommands(0, false);
        if (!brc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String protocolName = uri.getProtocol();
        String address = uri.getAddress();
        NetProtocol protocol = this.checkProtocol(protocolName);
        if (protocol == null || !protocol.valid) {
            return false;
        }
        if (NetProtocol.inproc.equals((Object)protocol)) {
            Ctx.Endpoint peer = this.findEndpoint(addr);
            int sndhwm = 0;
            if (peer.socket == null) {
                sndhwm = this.options.sendHwm;
            } else if (this.options.sendHwm != 0 && peer.options.recvHwm != 0) {
                sndhwm = this.options.sendHwm + peer.options.recvHwm;
            }
            int rcvhwm = 0;
            if (peer.socket == null) {
                rcvhwm = this.options.recvHwm;
            } else if (this.options.recvHwm != 0 && peer.options.sendHwm != 0) {
                rcvhwm = this.options.recvHwm + peer.options.sendHwm;
            }
            ZObject[] parents = new ZObject[]{this, peer.socket == null ? this : peer.socket};
            boolean conflate = this.options.conflate && (this.options.type == 5 || this.options.type == 7 || this.options.type == 8 || this.options.type == 1 || this.options.type == 2);
            int[] hwms = new int[]{conflate ? -1 : sndhwm, conflate ? -1 : rcvhwm};
            boolean[] conflates = new boolean[]{conflate, conflate};
            Pipe[] pipes = Pipe.pair(parents, hwms, conflates);
            this.attachPipe(pipes[0], true);
            if (peer.socket == null) {
                Msg id = new Msg(this.options.identitySize);
                id.put(this.options.identity, 0, (int)this.options.identitySize);
                id.setFlags(64);
                boolean written = pipes[0].write(id);
                assert (written);
                pipes[0].flush();
                this.pendConnection(addr, new Ctx.Endpoint(this, this.options), pipes);
            } else {
                boolean written;
                Msg id;
                if (peer.options.recvIdentity) {
                    id = new Msg(this.options.identitySize);
                    id.put(this.options.identity, 0, (int)this.options.identitySize);
                    id.setFlags(64);
                    written = pipes[0].write(id);
                    assert (written);
                    pipes[0].flush();
                }
                if (this.options.recvIdentity) {
                    id = new Msg(peer.options.identitySize);
                    id.put(peer.options.identity, 0, (int)peer.options.identitySize);
                    id.setFlags(64);
                    written = pipes[1].write(id);
                    assert (written);
                    pipes[1].flush();
                }
                this.sendBind(peer.socket, pipes[1], false);
            }
            this.options.lastEndpoint = addr;
            this.inprocs.insert(addr, pipes[0]);
            return true;
        }
        boolean bl = isSingleConnect = this.options.type == 5 || this.options.type == 2 || this.options.type == 3;
        if (isSingleConnect && this.endpoints.hasValues(addr)) {
            return true;
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        if (ioThread == null) {
            this.errno.set(156384766);
            return false;
        }
        Address paddr = new Address(protocolName, address);
        if (NetProtocol.tcp.equals((Object)protocol) || NetProtocol.ipc.equals((Object)protocol) || NetProtocol.tipc.equals((Object)protocol)) {
            paddr.resolve(this.options.ipv6);
        }
        if (NetProtocol.pgm.equals((Object)protocol) || NetProtocol.epgm.equals((Object)protocol)) {
            // empty if block
        }
        SessionBase session = Sockets.createSession(ioThread, true, this, this.options, paddr);
        assert (session != null);
        boolean subscribe2all = NetProtocol.pgm.equals((Object)protocol) || NetProtocol.epgm.equals((Object)protocol) || NetProtocol.norm.equals((Object)protocol);
        Pipe newpipe = null;
        if (this.options.immediate || subscribe2all) {
            ZObject[] parents = new ZObject[]{this, session};
            boolean conflate = this.options.conflate && (this.options.type == 5 || this.options.type == 7 || this.options.type == 8 || this.options.type == 1 || this.options.type == 2);
            int[] hwms = new int[]{conflate ? -1 : this.options.sendHwm, conflate ? -1 : this.options.recvHwm};
            boolean[] conflates = new boolean[]{conflate, conflate};
            Pipe[] pipes = Pipe.pair(parents, hwms, conflates);
            this.attachPipe(pipes[0], subscribe2all, true);
            newpipe = pipes[0];
            session.attachPipe(pipes[1]);
        }
        this.options.lastEndpoint = paddr.toString();
        this.addEndpoint(addr, session, newpipe);
        return true;
    }

    private void addEndpoint(String addr, Own endpoint, Pipe pipe) {
        this.launchChild(endpoint);
        this.endpoints.insert(addr, new EndpointPipe(endpoint, pipe));
    }

    public final boolean termEndpoint(String addr) {
        Collection<EndpointPipe> eps;
        TcpAddress address;
        boolean endpoint;
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return false;
        }
        if (addr == null) {
            this.errno.set(22);
            return false;
        }
        boolean rc = this.processCommands(0, false);
        if (!rc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        NetProtocol protocol = this.checkProtocol(uri.getProtocol());
        if (protocol == null || !protocol.valid) {
            return false;
        }
        if (NetProtocol.inproc.equals((Object)protocol)) {
            if (this.unregisterEndpoint(addr, this)) {
                return true;
            }
            Collection<Pipe> olds = this.inprocs.remove(addr);
            if (olds == null || olds.isEmpty()) {
                this.errno.set(2);
                return false;
            }
            for (Pipe old : olds) {
                old.terminate(true);
            }
            return true;
        }
        String resolvedAddress = addr;
        if (NetProtocol.tcp.equals((Object)protocol) && !(endpoint = this.endpoints.hasValues(resolvedAddress)) && !(endpoint = this.endpoints.hasValues(resolvedAddress = (address = new TcpAddress(uri.getAddress(), this.options.ipv6)).address().toString()))) {
            InetSocketAddress socketAddress = address.resolve(uri.getAddress(), this.options.ipv6, true);
            resolvedAddress = socketAddress.toString();
        }
        if ((eps = this.endpoints.remove(resolvedAddress)) == null || eps.isEmpty()) {
            this.errno.set(2);
            return false;
        }
        for (EndpointPipe ep : eps) {
            if (ep.pipe != null) {
                ep.pipe.terminate(true);
            }
            this.termChild(ep.endpoint);
        }
        return true;
    }

    public final boolean send(Msg msg, int flags) {
        block9: {
            long end;
            if (this.ctxTerminated) {
                this.errno.set(156384765);
                return false;
            }
            if (msg == null || !msg.check()) {
                this.errno.set(14);
                return false;
            }
            boolean brc = this.processCommands(0, true);
            if (!brc) {
                return false;
            }
            msg.resetFlags(1);
            if ((flags & 2) > 0) {
                msg.setFlags(1);
            }
            msg.resetMetadata();
            boolean rc = this.xsend(msg);
            if (rc) {
                return true;
            }
            if (this.errno.get() != 35) {
                return false;
            }
            if ((flags & 1) > 0 || this.options.sendTimeout == 0) {
                return false;
            }
            int timeout = this.options.sendTimeout;
            long l = end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
            do {
                if (!this.processCommands(timeout, false)) {
                    return false;
                }
                rc = this.xsend(msg);
                if (rc) break block9;
                if (this.errno.get() == 35) continue;
                return false;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
            this.errno.set(35);
            return false;
        }
        return true;
    }

    public final Msg recv(int flags) {
        Msg msg;
        block12: {
            if (this.ctxTerminated) {
                this.errno.set(156384765);
                return null;
            }
            if (++this.ticks == Config.INBOUND_POLL_RATE.getValue()) {
                if (!this.processCommands(0, false)) {
                    return null;
                }
                this.ticks = 0;
            }
            if ((msg = this.xrecv()) == null && this.errno.get() != 35) {
                return null;
            }
            if (msg != null) {
                if (this.fileDesc != null) {
                    msg.setFd(this.fileDesc);
                }
                this.extractFlags(msg);
                return msg;
            }
            if ((flags & 1) > 0 || this.options.recvTimeout == 0) {
                if (!this.processCommands(0, false)) {
                    return null;
                }
                this.ticks = 0;
                msg = this.xrecv();
                if (msg == null) {
                    return null;
                }
                this.extractFlags(msg);
                return msg;
            }
            int timeout = this.options.recvTimeout;
            long end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
            boolean block = this.ticks != 0;
            do {
                if (!this.processCommands(block ? timeout : 0, false)) {
                    return null;
                }
                msg = this.xrecv();
                if (msg != null) break block12;
                if (this.errno.get() != 35) {
                    return null;
                }
                block = true;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
            this.errno.set(35);
            return null;
        }
        this.ticks = 0;
        this.extractFlags(msg);
        return msg;
    }

    public final void close() {
        this.active = false;
        this.sendReap(this);
    }

    final boolean hasIn() {
        return this.xhasIn();
    }

    final boolean hasOut() {
        return this.xhasOut();
    }

    final void startReaping(Poller poller) {
        this.poller = poller;
        SelectableChannel fd = this.mailbox.getFd();
        this.handle = this.poller.addHandle(fd, this);
        this.poller.setPollIn(this.handle);
        this.terminate();
        this.checkDestroy();
    }

    private boolean processCommands(int timeout, boolean throttle) {
        Command cmd;
        if (timeout != 0) {
            cmd = this.mailbox.recv(timeout);
        } else {
            long tsc = 0L;
            if (tsc != 0L && throttle) {
                if (tsc >= this.lastTsc && tsc - this.lastTsc <= (long)Config.MAX_COMMAND_DELAY.getValue()) {
                    return true;
                }
                this.lastTsc = tsc;
            }
            cmd = this.mailbox.recv(0L);
        }
        while (cmd != null) {
            cmd.process();
            cmd = this.mailbox.recv(0L);
        }
        if (this.errno.get() == 4) {
            return false;
        }
        assert (this.errno.get() == 35) : this.errno;
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return false;
        }
        return true;
    }

    @Override
    protected final void processStop() {
        try {
            this.monitorSync.lock();
            this.stopMonitor();
            this.ctxTerminated = true;
        }
        finally {
            this.monitorSync.unlock();
        }
    }

    @Override
    protected final void processBind(Pipe pipe) {
        this.attachPipe(pipe, false);
    }

    @Override
    protected final void processTerm(int linger) {
        this.unregisterEndpoints(this);
        for (Pipe pipe : this.pipes) {
            pipe.terminate(false);
        }
        this.registerTermAcks(this.pipes.size());
        super.processTerm(linger);
    }

    @Override
    protected final void processDestroy() {
        this.destroyed = true;
    }

    protected boolean xsetsockopt(int option, Object optval) {
        this.errno.set(22);
        return false;
    }

    protected boolean xhasOut() {
        return false;
    }

    protected boolean xsend(Msg msg) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected boolean xhasIn() {
        return false;
    }

    protected Msg xrecv() {
        throw new UnsupportedOperationException("Must Override");
    }

    protected Blob getCredential() {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xreadActivated(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xwriteActivated(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xhiccuped(Pipe pipe) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public final void inEvent() {
        this.processCommands(0, false);
        this.checkDestroy();
    }

    private void checkDestroy() {
        if (this.destroyed) {
            this.poller.removeHandle(this.handle);
            this.destroySocket(this);
            this.sendReaped();
            super.processDestroy();
        }
    }

    @Override
    public final void readActivated(Pipe pipe) {
        this.xreadActivated(pipe);
    }

    @Override
    public final void writeActivated(Pipe pipe) {
        this.xwriteActivated(pipe);
    }

    @Override
    public final void hiccuped(Pipe pipe) {
        if (!this.options.immediate) {
            pipe.terminate(false);
        } else {
            this.xhiccuped(pipe);
        }
    }

    @Override
    public final void pipeTerminated(Pipe pipe) {
        this.xpipeTerminated(pipe);
        this.inprocs.remove(pipe);
        this.pipes.remove(pipe);
        if (this.isTerminating()) {
            this.unregisterTermAck();
        }
    }

    private void extractFlags(Msg msg) {
        if (msg.isIdentity()) assert (this.options.recvIdentity);
        this.rcvmore = msg.hasMore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean monitor(String addr, int events) {
        try {
            this.monitorSync.lock();
            if (this.ctxTerminated) {
                this.errno.set(156384765);
                boolean bl = false;
                return bl;
            }
            if (addr == null) {
                this.stopMonitor();
                boolean bl = true;
                return bl;
            }
            SimpleURI uri = SimpleURI.create(addr);
            NetProtocol protocol = this.checkProtocol(uri.getProtocol());
            if (protocol == null || !protocol.valid) {
                boolean bl = false;
                return bl;
            }
            if (!NetProtocol.inproc.equals((Object)protocol)) {
                this.errno.set(43);
                boolean bl = false;
                return bl;
            }
            this.monitorEvents = events;
            this.monitorSocket = this.getCtx().createSocket(0);
            if (this.monitorSocket == null) {
                boolean bl = false;
                return bl;
            }
            int linger = 0;
            try {
                this.monitorSocket.setSocketOpt(17, linger);
            }
            catch (IllegalArgumentException e) {
                this.stopMonitor();
                throw e;
            }
            boolean rc = this.monitorSocket.bind(addr);
            if (!rc) {
                this.stopMonitor();
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.monitorSync.unlock();
        }
    }

    public final void eventHandshaken(String addr, int zmtpVersion) {
        this.event(addr, zmtpVersion, 32768);
    }

    public final void eventConnected(String addr, SelectableChannel ch) {
        this.event(addr, ch, 1);
    }

    public final void eventConnectDelayed(String addr, int errno) {
        this.event(addr, errno, 2);
    }

    public final void eventConnectRetried(String addr, int interval) {
        try {
            this.monitorSync.lock();
            if ((this.monitorEvents & 4) == 0) {
                return;
            }
            this.monitorEvent(new ZMQ.Event(4, addr, interval));
        }
        finally {
            this.monitorSync.unlock();
        }
    }

    public final void eventListening(String addr, SelectableChannel ch) {
        this.event(addr, ch, 8);
    }

    public final void eventBindFailed(String addr, int errno) {
        this.event(addr, errno, 16);
    }

    public final void eventAccepted(String addr, SelectableChannel ch) {
        this.event(addr, ch, 32);
    }

    public final void eventAcceptFailed(String addr, int errno) {
        this.event(addr, errno, 64);
    }

    public final void eventClosed(String addr, SelectableChannel ch) {
        this.event(addr, ch, 128);
    }

    public final void eventCloseFailed(String addr, int errno) {
        this.event(addr, errno, 256);
    }

    public final void eventDisconnected(String addr, SelectableChannel ch) {
        this.event(addr, ch, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void event(String addr, Object arg, int event) {
        try {
            this.monitorSync.lock();
            if ((this.monitorEvents & event) == 0) {
                return;
            }
            this.monitorEvent(new ZMQ.Event(event, addr, arg));
        }
        finally {
            this.monitorSync.unlock();
        }
    }

    protected final void monitorEvent(ZMQ.Event event) {
        if (this.monitorSocket == null) {
            return;
        }
        event.write(this.monitorSocket);
    }

    private void stopMonitor() {
        if (this.monitorSocket != null) {
            if ((this.monitorEvents & 0x400) != 0) {
                this.monitorEvent(new ZMQ.Event(1024, "", 0));
            }
            this.monitorSocket.close();
            this.monitorSocket = null;
            this.monitorEvents = 0;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.options.socketId + "]";
    }

    public final SelectableChannel getFD() {
        return this.mailbox.getFd();
    }

    public String typeString() {
        return Sockets.name(this.options.type);
    }

    public final int errno() {
        return this.errno.get();
    }

    private static class SimpleURI {
        private final String protocol;
        private final String address;

        private SimpleURI(String protocol, String address) {
            this.protocol = protocol;
            this.address = address;
        }

        public static SimpleURI create(String value) {
            int pos = value.indexOf("://");
            if (pos < 0) {
                throw new IllegalArgumentException("Invalid URI: " + value);
            }
            String protocol = value.substring(0, pos);
            String address = value.substring(pos + 3);
            if (protocol.isEmpty() || address.isEmpty()) {
                throw new IllegalArgumentException("Invalid URI: " + value);
            }
            return new SimpleURI(protocol, address);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getAddress() {
            return this.address;
        }
    }

    private static class EndpointPipe {
        private final Own endpoint;
        private final Pipe pipe;

        public EndpointPipe(Own endpoint, Pipe pipe) {
            this.endpoint = endpoint;
            this.pipe = pipe;
        }

        public String toString() {
            return "EndpointPipe [endpoint=" + this.endpoint + ", pipe=" + this.pipe + "]";
        }
    }
}

