/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.systeminfo.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v95.systeminfo.model.GPUDevice;
import org.openqa.selenium.devtools.v95.systeminfo.model.ImageDecodeAcceleratorCapability;
import org.openqa.selenium.devtools.v95.systeminfo.model.VideoDecodeAcceleratorCapability;
import org.openqa.selenium.devtools.v95.systeminfo.model.VideoEncodeAcceleratorCapability;
import org.openqa.selenium.json.JsonInput;

public class GPUInfo {
    private final List<GPUDevice> devices;
    private final Optional<Map<String, Object>> auxAttributes;
    private final Optional<Map<String, Object>> featureStatus;
    private final List<String> driverBugWorkarounds;
    private final List<VideoDecodeAcceleratorCapability> videoDecoding;
    private final List<VideoEncodeAcceleratorCapability> videoEncoding;
    private final List<ImageDecodeAcceleratorCapability> imageDecoding;

    public GPUInfo(List<GPUDevice> devices, Optional<Map<String, Object>> auxAttributes, Optional<Map<String, Object>> featureStatus, List<String> driverBugWorkarounds, List<VideoDecodeAcceleratorCapability> videoDecoding, List<VideoEncodeAcceleratorCapability> videoEncoding, List<ImageDecodeAcceleratorCapability> imageDecoding) {
        this.devices = Objects.requireNonNull(devices, "devices is required");
        this.auxAttributes = auxAttributes;
        this.featureStatus = featureStatus;
        this.driverBugWorkarounds = Objects.requireNonNull(driverBugWorkarounds, "driverBugWorkarounds is required");
        this.videoDecoding = Objects.requireNonNull(videoDecoding, "videoDecoding is required");
        this.videoEncoding = Objects.requireNonNull(videoEncoding, "videoEncoding is required");
        this.imageDecoding = Objects.requireNonNull(imageDecoding, "imageDecoding is required");
    }

    public List<GPUDevice> getDevices() {
        return this.devices;
    }

    public Optional<Map<String, Object>> getAuxAttributes() {
        return this.auxAttributes;
    }

    public Optional<Map<String, Object>> getFeatureStatus() {
        return this.featureStatus;
    }

    public List<String> getDriverBugWorkarounds() {
        return this.driverBugWorkarounds;
    }

    public List<VideoDecodeAcceleratorCapability> getVideoDecoding() {
        return this.videoDecoding;
    }

    public List<VideoEncodeAcceleratorCapability> getVideoEncoding() {
        return this.videoEncoding;
    }

    public List<ImageDecodeAcceleratorCapability> getImageDecoding() {
        return this.imageDecoding;
    }

    private static GPUInfo fromJson(JsonInput input) {
        List devices = null;
        Optional<Map<String, Object>> auxAttributes = Optional.empty();
        Optional<Map<String, Object>> featureStatus = Optional.empty();
        List driverBugWorkarounds = null;
        List videoDecoding = null;
        List videoEncoding = null;
        List imageDecoding = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "devices": {
                    devices = (List)input.read(new TypeToken<List<GPUDevice>>(){}.getType());
                    continue block18;
                }
                case "auxAttributes": {
                    auxAttributes = Optional.ofNullable((Map)input.read(new TypeToken<Map<String, Object>>(){}.getType()));
                    continue block18;
                }
                case "featureStatus": {
                    featureStatus = Optional.ofNullable((Map)input.read(new TypeToken<Map<String, Object>>(){}.getType()));
                    continue block18;
                }
                case "driverBugWorkarounds": {
                    driverBugWorkarounds = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block18;
                }
                case "videoDecoding": {
                    videoDecoding = (List)input.read(new TypeToken<List<VideoDecodeAcceleratorCapability>>(){}.getType());
                    continue block18;
                }
                case "videoEncoding": {
                    videoEncoding = (List)input.read(new TypeToken<List<VideoEncodeAcceleratorCapability>>(){}.getType());
                    continue block18;
                }
                case "imageDecoding": {
                    imageDecoding = (List)input.read(new TypeToken<List<ImageDecodeAcceleratorCapability>>(){}.getType());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GPUInfo(devices, auxAttributes, featureStatus, driverBugWorkarounds, videoDecoding, videoEncoding, imageDecoding);
    }
}

