/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.accessibility.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v95.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AXRelatedNode {
    private final BackendNodeId backendDOMNodeId;
    private final Optional<String> idref;
    private final Optional<String> text;

    public AXRelatedNode(BackendNodeId backendDOMNodeId, Optional<String> idref, Optional<String> text) {
        this.backendDOMNodeId = Objects.requireNonNull(backendDOMNodeId, "backendDOMNodeId is required");
        this.idref = idref;
        this.text = text;
    }

    public BackendNodeId getBackendDOMNodeId() {
        return this.backendDOMNodeId;
    }

    public Optional<String> getIdref() {
        return this.idref;
    }

    public Optional<String> getText() {
        return this.text;
    }

    private static AXRelatedNode fromJson(JsonInput input) {
        BackendNodeId backendDOMNodeId = null;
        Optional<String> idref = Optional.empty();
        Optional<String> text = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "backendDOMNodeId": {
                    backendDOMNodeId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                    continue block10;
                }
                case "idref": {
                    idref = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "text": {
                    text = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXRelatedNode(backendDOMNodeId, idref, text);
    }
}

