/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Internal;
import graphql.language.NamedNode;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.schema.SchemaTransformer;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGeneratorDirectiveHelper;
import graphql.schema.idl.SchemaGeneratorPostProcessing;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@Internal
class SchemaDirectiveWiringSchemaGeneratorPostProcessing
implements SchemaGeneratorPostProcessing {
    private final SchemaGeneratorDirectiveHelper generatorDirectiveHelper = new SchemaGeneratorDirectiveHelper();
    private final TypeDefinitionRegistry typeRegistry;
    private final RuntimeWiring runtimeWiring;
    private final GraphQLCodeRegistry.Builder codeRegistryBuilder;
    private final Map<String, Object> directiveBehaviourContext = new HashMap<String, Object>();

    public SchemaDirectiveWiringSchemaGeneratorPostProcessing(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        this.typeRegistry = typeRegistry;
        this.runtimeWiring = runtimeWiring;
        this.codeRegistryBuilder = codeRegistryBuilder;
    }

    @Override
    public GraphQLSchema process(GraphQLSchema originalSchema) {
        this.codeRegistryBuilder.trackChanges();
        Visitor visitor = new Visitor();
        GraphQLSchema newSchema = SchemaTransformer.transformSchema(originalSchema, (GraphQLTypeVisitor)visitor);
        if (visitor.schemaChanged() || this.codeRegistryBuilder.hasChanged()) {
            return newSchema.transform(builder -> {
                GraphQLCodeRegistry codeRegistry = this.codeRegistryBuilder.build();
                builder.codeRegistry(codeRegistry);
            });
        }
        return newSchema;
    }

    public class Visitor
    extends GraphQLTypeVisitorStub {
        private boolean schemaChanged = false;

        public boolean schemaChanged() {
            return this.schemaChanged;
        }

        private SchemaGeneratorDirectiveHelper.Parameters mkBehaviourParams() {
            return new SchemaGeneratorDirectiveHelper.Parameters(SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.typeRegistry, SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.runtimeWiring, SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.directiveBehaviourContext, SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.codeRegistryBuilder);
        }

        private TraversalControl changOrContinue(GraphQLSchemaElement node, GraphQLSchemaElement newNode, TraverserContext<GraphQLSchemaElement> context) {
            if (node != newNode) {
                TreeTransformerUtil.changeNode(context, newNode);
                this.schemaChanged = true;
            }
            return TraversalControl.CONTINUE;
        }

        private boolean isIntrospectionType(GraphQLNamedType type) {
            return type.getName().startsWith("__");
        }

        private <T extends GraphQLNamedType> boolean notSuitable(T node, Function<T, NamedNode<?>> suitableFunc) {
            if (this.isIntrospectionType(node)) {
                return true;
            }
            NamedNode<?> definition = suitableFunc.apply(node);
            return definition == null;
        }

        @Override
        public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLObjectType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLObjectType newNode = SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.generatorDirectiveHelper.onObject(node, this.mkBehaviourParams());
            return this.changOrContinue(node, newNode, context);
        }

        @Override
        public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLInterfaceType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLInterfaceType newNode = SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.generatorDirectiveHelper.onInterface(node, this.mkBehaviourParams());
            return this.changOrContinue(node, newNode, context);
        }

        @Override
        public TraversalControl visitGraphQLEnumType(GraphQLEnumType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLEnumType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLEnumType newNode = SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.generatorDirectiveHelper.onEnum(node, this.mkBehaviourParams());
            return this.changOrContinue(node, newNode, context);
        }

        @Override
        public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLInputObjectType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLInputObjectType newNode = SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.generatorDirectiveHelper.onInputObjectType(node, this.mkBehaviourParams());
            return this.changOrContinue(node, newNode, context);
        }

        @Override
        public TraversalControl visitGraphQLScalarType(GraphQLScalarType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLScalarType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLScalarType newNode = SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.generatorDirectiveHelper.onScalar(node, this.mkBehaviourParams());
            return this.changOrContinue(node, newNode, context);
        }

        @Override
        public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLUnionType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLUnionType newNode = SchemaDirectiveWiringSchemaGeneratorPostProcessing.this.generatorDirectiveHelper.onUnion(node, this.mkBehaviourParams());
            return this.changOrContinue(node, newNode, context);
        }
    }
}

