/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Optional;
import java.util.function.Supplier;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoveFromSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue newSessionQueue;
    private final RequestId id;

    RemoveFromSessionQueue(Tracer tracer, NewSessionQueue newSessionQueue, RequestId id) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.newSessionQueue = Require.nonNull("New Session Queue", newSessionQueue);
        this.id = id;
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueue.remove");){
            Tags.HTTP_REQUEST.accept(span, req);
            Optional<SessionRequest> sessionRequest = this.newSessionQueue.remove(this.id);
            HttpResponse response = new HttpResponse();
            if (sessionRequest.isPresent()) {
                HttpResponse httpResponse = (HttpResponse)response.setContent((Supplier)Contents.asJson(sessionRequest));
                return httpResponse;
            }
            response.setStatus(204);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

