/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.internal.Require;

@Beta
public class Reference {
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String LEGACY_DEFAULT_DOMAIN = "index.docker.io";
    private static final String DEFAULT_REPO = "library";
    private static final String DEFAULT_TAG = "latest";
    private final String domain;
    private final String name;
    private final String tag;
    private final String digest;

    @VisibleForTesting
    Reference(String domain, String name, String tag, String digest) {
        this.domain = Require.nonNull("Domain", domain);
        this.name = Require.nonNull("Name", name);
        this.tag = tag;
        this.digest = digest;
    }

    public static Reference parse(String input) {
        String name;
        Require.nonNull("Reference to parse", input);
        ImmutableMap<String, String> splitDockerDomain = Reference.splitDockerDomain(input);
        String domain = splitDockerDomain.get("domain");
        String remainder = splitDockerDomain.get("remainder");
        String digest = null;
        String tag = DEFAULT_TAG;
        int digestSep = remainder.indexOf("@");
        int tagSep = remainder.indexOf(":");
        if (digestSep > -1 && tagSep > -1) {
            digest = remainder.substring(digestSep + 1);
            name = remainder.substring(0, digestSep);
            tag = null;
        } else if (tagSep > -1) {
            tag = remainder.substring(tagSep + 1);
            name = remainder.substring(0, tagSep);
        } else {
            name = remainder;
        }
        if (!name.toLowerCase().equals(name)) {
            throw new DockerException(String.format("Invalid reference format: repository name (%s) must be lowercase", name));
        }
        return new Reference(domain, name, tag, digest);
    }

    private static ImmutableMap<String, String> splitDockerDomain(String name) {
        String domain;
        String remainder;
        String possibleDomain;
        int domSep = name.indexOf("/");
        String string = possibleDomain = domSep == -1 ? "" : name.substring(0, domSep);
        if (domSep == -1 || !possibleDomain.contains(".") && !possibleDomain.contains(":") && !"localhost".equalsIgnoreCase(possibleDomain) && possibleDomain.toLowerCase().equals(possibleDomain)) {
            remainder = name;
            domain = DEFAULT_DOMAIN;
        } else {
            domain = possibleDomain;
            remainder = name.substring(domSep + 1);
        }
        if (LEGACY_DEFAULT_DOMAIN.equals(domain)) {
            domain = DEFAULT_DOMAIN;
        }
        if (DEFAULT_DOMAIN.equals(domain) && !remainder.contains("/")) {
            remainder = String.format("%s/%s", DEFAULT_REPO, remainder);
        }
        return ImmutableMap.of("domain", domain, "remainder", remainder);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getFamiliarName() {
        StringBuilder familiar = new StringBuilder();
        if (!DEFAULT_DOMAIN.equals(this.domain)) {
            familiar.append(this.domain).append("/");
        }
        if (this.name.contains(DEFAULT_REPO) && DEFAULT_DOMAIN.equals(this.domain)) {
            familiar.append(this.name.replace("library/", ""));
        } else {
            familiar.append(this.name);
        }
        if (this.digest != null) {
            familiar.append("@").append(this.digest);
        } else if (this.tag != null) {
            familiar.append(":").append(this.tag);
        } else {
            throw new DockerException("Unable to form familiar name: " + this);
        }
        return familiar.toString();
    }

    public String toString() {
        return "Reference{domain='" + this.domain + '\'' + ", name='" + this.name + '\'' + ", tag='" + this.tag + '\'' + ", digest='" + this.digest + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference that = (Reference)o;
        return this.domain.equals(that.domain) && this.name.equals(that.name) && Objects.equals(this.tag, that.tag) && Objects.equals(this.digest, that.digest);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.name, this.tag, this.digest);
    }
}

