/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.Internal;
import graphql.language.SourceLocation;
import graphql.parser.InvalidSyntaxException;
import java.io.IOException;
import java.io.StringWriter;

@Internal
public class UnicodeUtil {
    public static int MAX_UNICODE_CODE_POINT = 0x10FFFF;
    public static int LEADING_SURROGATE_LOWER_BOUND = 55296;
    public static int LEADING_SURROGATE_UPPER_BOUND = 56319;
    public static int TRAILING_SURROGATE_LOWER_BOUND = 56320;
    public static int TRAILING_SURROGATE_UPPER_BOUND = 57343;

    public static int parseAndWriteUnicode(StringWriter writer, String string, int i, SourceLocation sourceLocation) {
        int startIndex = UnicodeUtil.isBracedEscape(string, i) ? i + 2 : i + 1;
        int endIndexExclusive = UnicodeUtil.getEndIndexExclusive(string, i, sourceLocation);
        int continueIndex = UnicodeUtil.isBracedEscape(string, i) ? endIndexExclusive : endIndexExclusive - 1;
        String hexStr = string.substring(startIndex, endIndexExclusive);
        Integer codePoint = Integer.parseInt(hexStr, 16);
        if (UnicodeUtil.isTrailingSurrogateValue(codePoint)) {
            throw new InvalidSyntaxException(sourceLocation, "Invalid unicode - trailing surrogate must be preceded with a leading surrogate -", null, string.substring(i - 1, continueIndex + 1), null);
        }
        if (UnicodeUtil.isLeadingSurrogateValue(codePoint)) {
            if (!UnicodeUtil.isEscapedUnicode(string, continueIndex + 1)) {
                throw new InvalidSyntaxException(sourceLocation, "Invalid unicode - leading surrogate must be followed by a trailing surrogate -", null, string.substring(i - 1, continueIndex + 1), null);
            }
            i = continueIndex + 2;
            int trailingStartIndex = UnicodeUtil.isBracedEscape(string, i) ? i + 2 : i + 1;
            int trailingEndIndexExclusive = UnicodeUtil.getEndIndexExclusive(string, i, sourceLocation);
            String trailingHexStr = string.substring(trailingStartIndex, trailingEndIndexExclusive);
            Integer trailingCodePoint = Integer.parseInt(trailingHexStr, 16);
            int n = continueIndex = UnicodeUtil.isBracedEscape(string, i) ? trailingEndIndexExclusive : trailingEndIndexExclusive - 1;
            if (UnicodeUtil.isTrailingSurrogateValue(trailingCodePoint)) {
                UnicodeUtil.writeCodePoint(writer, codePoint);
                UnicodeUtil.writeCodePoint(writer, trailingCodePoint);
                return continueIndex;
            }
            throw new InvalidSyntaxException(sourceLocation, "Invalid unicode - leading surrogate must be followed by a trailing surrogate -", null, string.substring(i - 1, continueIndex + 1), null);
        }
        if (UnicodeUtil.isValidUnicodeCodePoint(codePoint)) {
            UnicodeUtil.writeCodePoint(writer, codePoint);
            return continueIndex;
        }
        throw new InvalidSyntaxException(sourceLocation, "Invalid unicode - not a valid code point -", null, string.substring(i - 1, continueIndex + 1), null);
    }

    private static int getEndIndexExclusive(String string, int i, SourceLocation sourceLocation) {
        if (string.length() > i + 5 && !UnicodeUtil.isBracedEscape(string, i)) {
            return i + 5;
        }
        int endIndexExclusive = i + 2;
        do {
            if (endIndexExclusive + 1 < string.length()) continue;
            throw new InvalidSyntaxException(sourceLocation, "Invalid unicode - incorrectly formatted escape -", null, string.substring(i - 1, endIndexExclusive), null);
        } while (string.charAt(++endIndexExclusive) != '}');
        return endIndexExclusive;
    }

    private static boolean isValidUnicodeCodePoint(int value) {
        return value <= MAX_UNICODE_CODE_POINT;
    }

    private static boolean isEscapedUnicode(String string, int index) {
        if (index + 1 >= string.length()) {
            return false;
        }
        return string.charAt(index) == '\\' && string.charAt(index + 1) == 'u';
    }

    private static boolean isLeadingSurrogateValue(int value) {
        return LEADING_SURROGATE_LOWER_BOUND <= value && value <= LEADING_SURROGATE_UPPER_BOUND;
    }

    private static boolean isTrailingSurrogateValue(int value) {
        return TRAILING_SURROGATE_LOWER_BOUND <= value && value <= TRAILING_SURROGATE_UPPER_BOUND;
    }

    private static void writeCodePoint(StringWriter writer, int codepoint) {
        char[] chars = Character.toChars(codepoint);
        try {
            writer.write(chars);
        }
        catch (IOException e) {
            Assert.assertShouldNeverHappen();
        }
    }

    private static boolean isBracedEscape(String string, int i) {
        return string.charAt(i + 1) == '{';
    }
}

