/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.zeromq.Utils;
import zmq.util.Objects;

public class ZBeacon {
    public static final long DEFAULT_BROADCAST_INTERVAL = 1000L;
    public static final String DEFAULT_BROADCAST_HOST = "255.255.255.255";
    private static final byte[] DEFAULT_BROADCAST_ADDRESS = new byte[]{0, 0, 0, 0};
    private final BroadcastClient broadcastClient;
    private final BroadcastServer broadcastServer;
    private final AtomicReference<byte[]> prefix = new AtomicReference<byte[]>(new byte[0]);
    private final AtomicReference<byte[]> beacon = new AtomicReference<byte[]>(new byte[0]);
    private final AtomicLong broadcastInterval = new AtomicLong(1000L);
    private final AtomicReference<Listener> listener = new AtomicReference();
    private AtomicReference<Thread.UncaughtExceptionHandler> clientHandler = new AtomicReference();
    private AtomicReference<Thread.UncaughtExceptionHandler> serverHandler = new AtomicReference();

    public ZBeacon(int port, byte[] beacon) {
        this(DEFAULT_BROADCAST_HOST, port, beacon);
    }

    public ZBeacon(String host, int port, byte[] beacon) {
        this(host, port, beacon, true);
    }

    public ZBeacon(String host, int port, byte[] beacon, boolean ignoreLocalAddress) {
        this(host, port, beacon, ignoreLocalAddress, false);
    }

    public ZBeacon(String host, int port, byte[] beacon, boolean ignoreLocalAddress, boolean blocking) {
        this(host, DEFAULT_BROADCAST_ADDRESS, port, beacon, 1000L, ignoreLocalAddress, blocking);
    }

    public ZBeacon(String broadcastAddress, byte[] serverAddress, int port, byte[] beacon, long broadcastInterval, boolean ignoreLocalAddress, boolean blocking) {
        Objects.requireNonNull(broadcastAddress, "Host cannot be null");
        Objects.requireNonNull(serverAddress, "Server address cannot be null");
        Objects.requireNonNull(beacon, "Beacon cannot be null");
        this.broadcastInterval.set(broadcastInterval);
        this.beacon.set(beacon);
        this.broadcastServer = new BroadcastServer(serverAddress, port, ignoreLocalAddress, blocking);
        this.broadcastClient = new BroadcastClient(serverAddress, broadcastAddress, port, this.broadcastInterval);
    }

    public void setUncaughtExceptionHandlers(Thread.UncaughtExceptionHandler clientHandler, Thread.UncaughtExceptionHandler serverHandler) {
        this.clientHandler.set(clientHandler);
        this.serverHandler.set(serverHandler);
    }

    public void startClient() {
        if (!this.broadcastClient.isRunning) {
            if (this.broadcastClient.thread == null) {
                this.broadcastClient.thread = new Thread(this.broadcastClient);
                this.broadcastClient.thread.setName("ZBeacon Client Thread");
                this.broadcastClient.thread.setDaemon(true);
                this.broadcastClient.thread.setUncaughtExceptionHandler(this.clientHandler.get());
            }
            this.broadcastClient.thread.start();
        }
    }

    public void startServer() {
        if (!this.broadcastServer.isRunning && this.listener.get() != null) {
            if (this.broadcastServer.thread == null) {
                this.broadcastServer.thread = new Thread(this.broadcastServer);
                this.broadcastServer.thread.setName("ZBeacon Server Thread");
                this.broadcastServer.thread.setDaemon(true);
                this.broadcastServer.thread.setUncaughtExceptionHandler(this.serverHandler.get());
            }
            this.broadcastServer.thread.start();
        }
    }

    public void start() {
        this.startClient();
        this.startServer();
    }

    public void stop() throws InterruptedException {
        if (this.broadcastClient.thread != null) {
            this.broadcastClient.thread.interrupt();
            this.broadcastClient.thread.join();
        }
        if (this.broadcastServer.thread != null) {
            this.broadcastServer.thread.interrupt();
            this.broadcastServer.thread.join();
        }
    }

    public void setBeacon(byte[] beacon) {
        this.beacon.set(beacon);
    }

    public byte[] getBeacon() {
        return this.beacon.get();
    }

    public void setPrefix(byte[] prefix) {
        this.prefix.set(prefix);
    }

    public byte[] getPrefix() {
        return this.prefix.get();
    }

    public void setListener(Listener listener) {
        this.listener.set(listener);
    }

    public Listener getListener() {
        return this.listener.get();
    }

    public long getBroadcastInterval() {
        return this.broadcastInterval.get();
    }

    public void setBroadcastInterval(long broadcastInterval) {
        this.broadcastInterval.set(broadcastInterval);
    }

    static /* synthetic */ byte[] access$000() {
        return DEFAULT_BROADCAST_ADDRESS;
    }

    static /* synthetic */ AtomicReference access$500(ZBeacon x0) {
        return x0.beacon;
    }

    private class BroadcastServer
    implements Runnable {
        private final DatagramChannel handle;
        private final boolean ignoreLocalAddress;
        private Thread thread;
        private boolean isRunning;

        public BroadcastServer(byte[] serverAddress, int port, boolean ignoreLocalAddress, boolean blocking) {
            this.ignoreLocalAddress = ignoreLocalAddress;
            try {
                this.handle = DatagramChannel.open();
                this.handle.configureBlocking(blocking);
                this.handle.socket().setReuseAddress(true);
                this.handle.socket().bind(new InetSocketAddress(port));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleMessage(ByteBuffer buffer, int size, InetAddress from) {
            byte[] prefix = (byte[])ZBeacon.this.prefix.get();
            if (size < prefix.length) {
                return;
            }
            ByteBuffer buf = buffer.duplicate();
            buf.position(0);
            for (int i = 0; i < prefix.length; ++i) {
                if (buf.get() == prefix[i]) continue;
                return;
            }
            ((Listener)ZBeacon.this.listener.get()).onBeacon(from, Arrays.copyOf(buffer.array(), size));
        }
    }

    private class BroadcastClient
    implements Runnable {
        private DatagramChannel broadcastChannel;
        private final InetSocketAddress broadcastAddress;
        private final InetAddress interfaceAddress;
        private final AtomicLong broadcastInterval;
        private boolean isRunning;
        private Thread thread;

        public BroadcastClient(byte[] interfaceAddress, String broadcastAddress, int port, AtomicLong broadcastInterval) {
            this.broadcastInterval = broadcastInterval;
            try {
                this.broadcastAddress = new InetSocketAddress(InetAddress.getByName(broadcastAddress), port);
                this.interfaceAddress = InetAddress.getByAddress(interfaceAddress);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface Listener {
        public void onBeacon(InetAddress var1, byte[] var2);
    }

    public static class Builder {
        private String clientHost = "255.255.255.255";
        private byte[] serverAddr = ZBeacon.access$000();
        private int port;
        private long broadcastInterval = 1000L;
        private byte[] beacon;
        private boolean ignoreLocalAddress = true;
        private boolean blocking = false;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder beacon(byte[] beacon) {
            this.beacon = beacon;
            return this;
        }

        public Builder client(String host) {
            this.clientHost = host;
            return this;
        }

        public Builder server(byte[] addr) {
            Utils.checkArgument(addr.length == 4 || addr.length == 16, "Server Address has to be 4 or 16 bytes long");
            this.serverAddr = addr;
            return this;
        }

        public Builder ignoreLocalAddress(boolean ignoreLocalAddress) {
            this.ignoreLocalAddress = ignoreLocalAddress;
            return this;
        }

        public Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public Builder broadcastInterval(long broadcastInterval) {
            this.broadcastInterval = broadcastInterval;
            return this;
        }

        public ZBeacon build() {
            return new ZBeacon(this.clientHost, this.serverAddr, this.port, this.beacon, this.broadcastInterval, this.ignoreLocalAddress, this.blocking);
        }
    }
}

