/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.ErrorFilter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class SeleniumHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final HttpHandler seleniumHandler;

    public SeleniumHandler(HttpHandler seleniumHandler) {
        super(HttpRequest.class);
        this.seleniumHandler = Require.nonNull("HTTP handler", seleniumHandler).with(new ErrorFilter());
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) {
        EXECUTOR.submit(() -> {
            HttpResponse res = this.seleniumHandler.execute(msg);
            ctx.writeAndFlush(res);
        });
    }
}

