/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.SimplePropertyDescriptor;
import org.openqa.selenium.json.TypeCoercer;

class InstanceCoercer
extends TypeCoercer<Object> {
    private final JsonTypeCoercer coercer;

    InstanceCoercer(JsonTypeCoercer coercer) {
        this.coercer = Require.nonNull("Coercer", coercer);
    }

    @Override
    public boolean test(Class aClass) {
        try {
            this.getConstructor(aClass);
            return true;
        }
        catch (JsonException ex) {
            return false;
        }
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Object> apply(Type type) {
        Constructor<?> constructor = this.getConstructor(type);
        return (jsonInput, setter) -> {
            try {
                Map<String, TypeAndWriter> allWriters;
                Object instance = constructor.newInstance(new Object[0]);
                switch (setter) {
                    case BY_FIELD: {
                        allWriters = this.getFieldWriters(constructor);
                        break;
                    }
                    case BY_NAME: {
                        allWriters = this.getBeanWriters(constructor);
                        break;
                    }
                    default: {
                        throw new JsonException("Cannot determine how to find fields: " + (Object)setter);
                    }
                }
                jsonInput.beginObject();
                while (jsonInput.hasNext()) {
                    String key = jsonInput.nextName();
                    TypeAndWriter writer = allWriters.get(key);
                    if (writer == null) {
                        jsonInput.skipValue();
                        continue;
                    }
                    Object value = this.coercer.coerce((JsonInput)jsonInput, writer.type, (PropertySetting)((Object)setter));
                    writer.writer.accept(instance, value);
                }
                jsonInput.endObject();
                return instance;
            }
            catch (ReflectiveOperationException e) {
                throw new JsonException(e);
            }
        };
    }

    private Map<String, TypeAndWriter> getFieldWriters(Constructor<?> constructor) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<?> current = constructor.getDeclaringClass(); current != Object.class; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        return fields.stream().filter(field -> !Modifier.isTransient(field.getModifiers())).filter(field -> !Modifier.isStatic(field.getModifiers())).peek(field -> field.setAccessible(true)).collect(Collectors.toMap(Field::getName, field -> {
            Type type = field.getGenericType();
            BiConsumer<Object, Object> writer = (instance, value) -> {
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    throw new JsonException(e);
                }
            };
            return new TypeAndWriter(type, writer);
        }));
    }

    private Map<String, TypeAndWriter> getBeanWriters(Constructor<?> constructor) {
        return Stream.of(SimplePropertyDescriptor.getPropertyDescriptors(constructor.getDeclaringClass())).filter(desc -> desc.getWriteMethod() != null).collect(Collectors.toMap(SimplePropertyDescriptor::getName, desc -> {
            Type type = desc.getWriteMethod().getGenericParameterTypes()[0];
            BiConsumer<Object, Object> writer = (instance, value) -> {
                Method method = desc.getWriteMethod();
                method.setAccessible(true);
                try {
                    method.invoke(instance, value);
                }
                catch (ReflectiveOperationException e) {
                    throw new JsonException(e);
                }
            };
            return new TypeAndWriter(type, writer);
        }));
    }

    private Constructor<?> getConstructor(Type type) {
        Class<?> target = InstanceCoercer.getClss(type);
        try {
            Constructor<?> constructor = target.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw new JsonException(e);
        }
    }

    private static Class<?> getClss(Type type) {
        Type rawType;
        Class target = null;
        if (type instanceof Class) {
            target = (Class)type;
        } else if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            target = (Class)rawType;
        }
        if (target == null) {
            throw new JsonException("Cannot determine base class");
        }
        return target;
    }

    private static class TypeAndWriter {
        private final Type type;
        private final BiConsumer<Object, Object> writer;

        public TypeAndWriter(Type type, BiConsumer<Object, Object> writer) {
            this.type = type;
            this.writer = writer;
        }
    }
}

