/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.io.UncheckedIOException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class SessionCreated
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue queue;
    private final RequestId requestId;

    public SessionCreated(Tracer tracer, NewSessionQueue queue, RequestId requestId) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.queue = Require.nonNull("New Session Queue", queue);
        this.requestId = Require.nonNull("Request ID", requestId);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueue.created_ok");){
            Tags.HTTP_REQUEST.accept(span, req);
            CreateSessionResponse response = (CreateSessionResponse)Contents.fromJson(req, CreateSessionResponse.class);
            this.queue.complete(this.requestId, Either.right(response));
            HttpResponse res = new HttpResponse();
            Tags.HTTP_RESPONSE.accept(span, res);
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }
}

