/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum CookieSourceScheme {
    UNSET("Unset"),
    NONSECURE("NonSecure"),
    SECURE("Secure");

    private String value;

    private CookieSourceScheme(String value) {
        this.value = value;
    }

    public static CookieSourceScheme fromString(String s2) {
        return Arrays.stream(CookieSourceScheme.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CookieSourceScheme "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookieSourceScheme fromJson(JsonInput input) {
        return CookieSourceScheme.fromString(input.nextString());
    }
}

