/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.profiler.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v94.profiler.model.CoverageRange;
import org.openqa.selenium.json.JsonInput;

public class FunctionCoverage {
    private final String functionName;
    private final List<CoverageRange> ranges;
    private final Boolean isBlockCoverage;

    public FunctionCoverage(String functionName, List<CoverageRange> ranges, Boolean isBlockCoverage) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is required");
        this.ranges = Objects.requireNonNull(ranges, "ranges is required");
        this.isBlockCoverage = Objects.requireNonNull(isBlockCoverage, "isBlockCoverage is required");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<CoverageRange> getRanges() {
        return this.ranges;
    }

    public Boolean getIsBlockCoverage() {
        return this.isBlockCoverage;
    }

    private static FunctionCoverage fromJson(JsonInput input) {
        String functionName = null;
        List ranges = null;
        Boolean isBlockCoverage = false;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "functionName": {
                    functionName = input.nextString();
                    continue block10;
                }
                case "ranges": {
                    ranges = (List)input.read(new TypeToken<List<CoverageRange>>(){}.getType());
                    continue block10;
                }
                case "isBlockCoverage": {
                    isBlockCoverage = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FunctionCoverage(functionName, ranges, isBlockCoverage);
    }
}

