/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CountAggregator
implements Aggregator<LongAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    CountAggregator(Supplier<ExemplarReservoir> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongAccumulation merge(LongAccumulation previous, LongAccumulation current) {
        return LongAccumulation.create(previous.getValue() + current.getValue(), current.getExemplars());
    }

    @Override
    public LongAccumulation diff(LongAccumulation previous, LongAccumulation current) {
        return current;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibrary, MetricDescriptor metricDescriptor, Map<Attributes, LongAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createLongSum(resource, instrumentationLibrary, metricDescriptor.getName(), metricDescriptor.getDescription(), "1", LongSumData.create(true, temporality, MetricDataUtils.toLongPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<LongAccumulation> {
        private final LongAdder current = new LongAdder();

        private Handle(ExemplarReservoir exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.add(1L);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(1L);
        }

        @Override
        protected LongAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            return LongAccumulation.create(this.current.sumThenReset(), exemplars);
        }
    }
}

