/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.DefaultTraverserContext;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;

@Internal
public class TreeParallelTransformer<T> {
    private final Map<Class<?>, Object> rootVars = new ConcurrentHashMap();
    private final ForkJoinPool forkJoinPool;
    private final NodeAdapter<T> nodeAdapter;
    private Object sharedContextData;

    private TreeParallelTransformer(Object sharedContextData, ForkJoinPool forkJoinPool, NodeAdapter<T> nodeAdapter) {
        this.sharedContextData = sharedContextData;
        this.forkJoinPool = forkJoinPool;
        this.nodeAdapter = nodeAdapter;
    }

    public static <T> TreeParallelTransformer<T> parallelTransformer(NodeAdapter<T> nodeAdapter) {
        return TreeParallelTransformer.parallelTransformer(nodeAdapter, ForkJoinPool.commonPool());
    }

    public static <T> TreeParallelTransformer<T> parallelTransformer(NodeAdapter<T> nodeAdapter, ForkJoinPool forkJoinPool) {
        return new TreeParallelTransformer<T>(null, forkJoinPool, nodeAdapter);
    }

    public TreeParallelTransformer<T> rootVars(Map<Class<?>, Object> rootVars) {
        this.rootVars.putAll(Assert.assertNotNull(rootVars));
        return this;
    }

    public TreeParallelTransformer<T> rootVar(Class<?> key, Object value) {
        this.rootVars.put(key, value);
        return this;
    }

    public T transform(T root, TraverserVisitor<? super T> visitor) {
        return this.transformImpl(root, visitor);
    }

    public DefaultTraverserContext<T> newRootContext(Map<Class<?>, Object> vars) {
        return this.newContextImpl(null, null, vars, null, true);
    }

    public T transformImpl(T root, TraverserVisitor<? super T> visitor) {
        Assert.assertNotNull(root);
        Assert.assertNotNull(visitor);
        DefaultTraverserContext<T> rootContext = this.newRootContext(this.rootVars);
        DefaultTraverserContext<T> context = this.newContext(root, rootContext, null);
        EnterAction enterAction = new EnterAction(null, context, visitor);
        Object result = this.forkJoinPool.invoke(enterAction);
        return result;
    }

    private List<DefaultTraverserContext> pushAll(TraverserContext<T> traverserContext) {
        LinkedHashMap childrenContextMap = new LinkedHashMap();
        LinkedList<DefaultTraverserContext> contexts = new LinkedList<DefaultTraverserContext>();
        if (!traverserContext.isDeleted()) {
            Map<String, List<T>> childrenMap = this.nodeAdapter.getNamedChildren(traverserContext.thisNode());
            childrenMap.keySet().forEach(key -> {
                List children = (List)childrenMap.get(key);
                for (int i = children.size() - 1; i >= 0; --i) {
                    Object child = Assert.assertNotNull(children.get(i), () -> String.format("null child for key %s", key));
                    NodeLocation nodeLocation = new NodeLocation((String)key, i);
                    DefaultTraverserContext context = this.newContext(child, traverserContext, nodeLocation);
                    contexts.push(context);
                    childrenContextMap.computeIfAbsent(key, notUsed -> new ArrayList());
                    ((List)childrenContextMap.get(key)).add(0, context);
                }
            });
        }
        return contexts;
    }

    private DefaultTraverserContext<T> newContext(T o, TraverserContext<T> parent, NodeLocation position) {
        return this.newContextImpl(o, parent, new LinkedHashMap(), position, false);
    }

    private DefaultTraverserContext<T> newContextImpl(T curNode, TraverserContext<T> parent, Map<Class<?>, Object> vars, NodeLocation nodeLocation, boolean isRootContext) {
        Assert.assertNotNull(vars);
        return new DefaultTraverserContext<T>(curNode, parent, null, vars, this.sharedContextData, nodeLocation, isRootContext, true);
    }

    private class EnterAction
    extends CountedCompleter {
        private DefaultTraverserContext currentContext;
        private TraverserVisitor<? super T> visitor;
        private List<DefaultTraverserContext> children;
        private List<NodeZipper<T>> myZippers;
        private T result;

        private EnterAction(CountedCompleter parent, DefaultTraverserContext currentContext, TraverserVisitor<? super T> visitor) {
            super(parent);
            this.myZippers = new LinkedList();
            this.currentContext = currentContext;
            this.visitor = visitor;
        }

        @Override
        public void compute() {
            this.currentContext.setPhase(TraverserContext.Phase.ENTER);
            this.currentContext.setVar(List.class, this.myZippers);
            TraversalControl traversalControl = this.visitor.enter(this.currentContext);
            Assert.assertNotNull(traversalControl, () -> "result of enter must not be null");
            Assert.assertTrue(TraversalControl.QUIT != traversalControl, () -> "can't return QUIT for parallel traversing");
            if (traversalControl == TraversalControl.ABORT) {
                this.children = Collections.emptyList();
                this.tryComplete();
                return;
            }
            Assert.assertTrue(traversalControl == TraversalControl.CONTINUE);
            this.children = TreeParallelTransformer.this.pushAll(this.currentContext);
            if (this.children.size() == 0) {
                this.tryComplete();
                return;
            }
            this.setPendingCount(this.children.size() - 1);
            for (int i = 1; i < this.children.size(); ++i) {
                new EnterAction(this, this.children.get(i), this.visitor).fork();
            }
            new EnterAction(this, this.children.get(0), this.visitor).compute();
        }

        public void onCompletion(CountedCompleter caller) {
            NodeZipper newNode;
            if (this.currentContext.isDeleted()) {
                this.result = null;
                return;
            }
            LinkedList childZippers = new LinkedList();
            for (DefaultTraverserContext childContext : this.children) {
                childZippers.addAll(childContext.getVar(List.class));
            }
            if (childZippers.size() > 0) {
                newNode = this.moveUp(this.currentContext.thisNode(), childZippers);
                this.myZippers.add(newNode);
                this.result = newNode.getCurNode();
            } else if (this.currentContext.isChanged()) {
                newNode = new NodeZipper(this.currentContext.thisNode(), this.currentContext.getBreadcrumbs(), TreeParallelTransformer.this.nodeAdapter);
                this.myZippers.add(newNode);
                this.result = this.currentContext.thisNode();
            } else {
                this.result = this.currentContext.thisNode();
            }
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        private NodeZipper<T> moveUp(T parent, List<NodeZipper<T>> sameParent) {
            Assert.assertNotEmpty(sameParent, () -> "expected at least one zipper");
            HashMap childrenMap = new HashMap(TreeParallelTransformer.this.nodeAdapter.getNamedChildren(parent));
            HashMap<String, Integer> indexCorrection = new HashMap<String, Integer>();
            sameParent.sort((zipper1, zipper2) -> {
                NodeZipper.ModificationType modificationType2;
                int index2;
                int index1 = zipper1.getBreadcrumbs().get(0).getLocation().getIndex();
                if (index1 != (index2 = zipper2.getBreadcrumbs().get(0).getLocation().getIndex())) {
                    return Integer.compare(index1, index2);
                }
                NodeZipper.ModificationType modificationType1 = zipper1.getModificationType();
                if (modificationType1 == (modificationType2 = zipper2.getModificationType())) {
                    return 0;
                }
                if (modificationType1 == NodeZipper.ModificationType.REPLACE) {
                    return -1;
                }
                return modificationType1 == NodeZipper.ModificationType.INSERT_BEFORE ? -1 : 1;
            });
            for (NodeZipper zipper : sameParent) {
                NodeLocation location = zipper.getBreadcrumbs().get(0).getLocation();
                Integer ixDiff = indexCorrection.getOrDefault(location.getName(), 0);
                int ix = location.getIndex() + ixDiff;
                String name = location.getName();
                ArrayList childList = new ArrayList((Collection)childrenMap.get(name));
                switch (zipper.getModificationType()) {
                    case REPLACE: {
                        childList.set(ix, zipper.getCurNode());
                        break;
                    }
                    case DELETE: {
                        childList.remove(ix);
                        indexCorrection.put(name, ixDiff - 1);
                        break;
                    }
                    case INSERT_BEFORE: {
                        childList.add(ix, zipper.getCurNode());
                        indexCorrection.put(name, ixDiff + 1);
                        break;
                    }
                    case INSERT_AFTER: {
                        childList.add(ix + 1, zipper.getCurNode());
                        indexCorrection.put(name, ixDiff + 1);
                    }
                }
                childrenMap.put(name, childList);
            }
            Object newNode = TreeParallelTransformer.this.nodeAdapter.withNewChildren(parent, childrenMap);
            List newBreadcrumbs = sameParent.get(0).getBreadcrumbs().subList(1, sameParent.get(0).getBreadcrumbs().size());
            return new NodeZipper(newNode, newBreadcrumbs, TreeParallelTransformer.this.nodeAdapter);
        }
    }
}

