/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.service.processor;

import com.google.common.base.Charsets;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

final class ServicesFiles {
    public static final String SERVICES_PATH = "META-INF/services";

    private ServicesFiles() {
    }

    static String getPath(String serviceName) {
        return "META-INF/services/" + serviceName;
    }

    static Set<String> readServiceFile(InputStream input) throws IOException {
        HashSet<String> serviceClasses = new HashSet<String>();
        try (Closer closer = Closer.create();){
            String line;
            BufferedReader r = closer.register(new BufferedReader(new InputStreamReader(input, Charsets.UTF_8)));
            while ((line = r.readLine()) != null) {
                int commentStart = line.indexOf(35);
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).isEmpty()) continue;
                serviceClasses.add(line);
            }
            HashSet<String> hashSet = serviceClasses;
            return hashSet;
        }
    }

    static void writeServiceFile(Collection<String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, Charsets.UTF_8));
        for (String service : services) {
            writer.write(service);
            writer.newLine();
        }
        writer.flush();
    }
}

