/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Encodable;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.SourceType;
import org.openqa.selenium.internal.Require;

public class PointerInput
implements InputSource,
Encodable {
    private final Kind kind;
    private final String name;

    public PointerInput(Kind kind, String name) {
        this.kind = Require.nonNull("Kind of pointer device", kind);
        this.name = Optional.ofNullable(name).orElse(UUID.randomUUID().toString());
    }

    @Override
    public SourceType getInputType() {
        return SourceType.POINTER;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("type", this.getInputType().getType());
        toReturn.put("id", this.name);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("pointerType", this.kind.getWireName());
        toReturn.put("parameters", parameters);
        return toReturn;
    }

    public Interaction createPointerMove(Duration duration, Origin origin, int x, int y) {
        return new Move(this, duration, origin, x, y);
    }

    public Interaction createPointerDown(int button) {
        return new PointerPress(this, PointerPress.Direction.DOWN, button);
    }

    public Interaction createPointerUp(int button) {
        return new PointerPress(this, PointerPress.Direction.UP, button);
    }

    public static final class Origin {
        private final Object originObject;

        public Object asArg() {
            Object arg = this.originObject;
            while (arg instanceof WrapsElement) {
                arg = ((WrapsElement)arg).getWrappedElement();
            }
            return arg;
        }

        private Origin(Object originObject) {
            this.originObject = originObject;
        }

        public static Origin pointer() {
            return new Origin("pointer");
        }

        public static Origin viewport() {
            return new Origin("viewport");
        }

        public static Origin fromElement(WebElement element) {
            return new Origin(Require.nonNull("Element", element));
        }
    }

    public static enum MouseButton {
        LEFT(0),
        MIDDLE(1),
        RIGHT(2);

        private final int button;

        private MouseButton(int button) {
            this.button = button;
        }

        public int asArg() {
            return this.button;
        }
    }

    public static enum Kind {
        MOUSE("mouse"),
        PEN("pen"),
        TOUCH("touch");

        private final String wireName;

        private Kind(String pointerSubType) {
            this.wireName = pointerSubType;
        }

        public String getWireName() {
            return this.wireName;
        }
    }

    private static class Move
    extends Interaction
    implements Encodable {
        private final Origin origin;
        private final int x;
        private final int y;
        private final Duration duration;

        protected Move(InputSource source, Duration duration, Origin origin, int x, int y) {
            super(source);
            this.origin = Require.nonNull("Origin of move", origin);
            this.x = x;
            this.y = y;
            this.duration = Require.nonNegative(duration);
        }

        @Override
        protected boolean isValidFor(SourceType sourceType) {
            return SourceType.POINTER == sourceType;
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("type", "pointerMove");
            toReturn.put("duration", this.duration.toMillis());
            toReturn.put("origin", this.origin.asArg());
            toReturn.put("x", this.x);
            toReturn.put("y", this.y);
            return toReturn;
        }
    }

    private static class PointerPress
    extends Interaction
    implements Encodable {
        private final Direction direction;
        private final int button;

        public PointerPress(InputSource source, Direction direction, int button) {
            super(source);
            if (button < 0) {
                throw new IllegalStateException(String.format("Button must be greater than or equal to 0: %d", button));
            }
            this.direction = Require.nonNull("Direction of move", direction);
            this.button = button;
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("type", this.direction.getType());
            toReturn.put("button", this.button);
            return toReturn;
        }

        static enum Direction {
            DOWN("pointerDown"),
            UP("pointerUp");

            private final String type;

            private Direction(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }
}

