/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.data.SessionRequestCapability;
import org.openqa.selenium.grid.security.RequiresSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.sessionqueue.AddBackToSessionQueue;
import org.openqa.selenium.grid.sessionqueue.AddToSessionQueue;
import org.openqa.selenium.grid.sessionqueue.ClearSessionQueue;
import org.openqa.selenium.grid.sessionqueue.GetNextMatchingRequest;
import org.openqa.selenium.grid.sessionqueue.GetSessionQueue;
import org.openqa.selenium.grid.sessionqueue.RemoveFromSessionQueue;
import org.openqa.selenium.grid.sessionqueue.SessionCreated;
import org.openqa.selenium.grid.sessionqueue.SessionNotCreated;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class NewSessionQueue
implements HasReadyState,
Routable {
    protected final Tracer tracer;
    private final Route routes;

    protected NewSessionQueue(Tracer tracer, Secret registrationSecret) {
        this.tracer = Require.nonNull("Tracer", tracer);
        Require.nonNull("Registration secret", registrationSecret);
        RequiresSecretFilter requiresSecret = new RequiresSecretFilter(registrationSecret);
        this.routes = Route.combine(Route.post("/session").to(() -> req -> {
            SessionRequest sessionRequest = new SessionRequest(new RequestId(UUID.randomUUID()), req, Instant.now());
            return this.addToQueue(sessionRequest);
        }), new Routable[]{Route.post("/se/grid/newsessionqueue/session").to(() -> new AddToSessionQueue(tracer, this)).with(requiresSecret), Route.post("/se/grid/newsessionqueue/session/{requestId}/retry").to(params -> new AddBackToSessionQueue(tracer, this, this.requestIdFrom((Map<String, String>)params))).with(requiresSecret), Route.post("/se/grid/newsessionqueue/session/{requestId}/failure").to(params -> new SessionNotCreated(tracer, this, this.requestIdFrom((Map<String, String>)params))).with(requiresSecret), Route.post("/se/grid/newsessionqueue/session/{requestId}/success").to(params -> new SessionCreated(tracer, this, this.requestIdFrom((Map<String, String>)params))).with(requiresSecret), Route.post("/se/grid/newsessionqueue/session/{requestId}").to(params -> new RemoveFromSessionQueue(tracer, this, this.requestIdFrom((Map<String, String>)params))).with(requiresSecret), Route.post("/se/grid/newsessionqueue/session/next").to(() -> new GetNextMatchingRequest(tracer, this)).with(requiresSecret), Route.get("/se/grid/newsessionqueue/queue").to(() -> new GetSessionQueue(tracer, this)), Route.delete("/se/grid/newsessionqueue/queue").to(() -> new ClearSessionQueue(tracer, this)).with(requiresSecret)});
    }

    private RequestId requestIdFrom(Map<String, String> params) {
        return new RequestId(UUID.fromString(params.get("requestId")));
    }

    public abstract HttpResponse addToQueue(SessionRequest var1);

    public abstract boolean retryAddToQueue(SessionRequest var1);

    public abstract Optional<SessionRequest> remove(RequestId var1);

    public abstract Optional<SessionRequest> getNextAvailable(Set<Capabilities> var1);

    public abstract void complete(RequestId var1, Either<SessionNotCreatedException, CreateSessionResponse> var2);

    public abstract int clearQueue();

    public abstract List<SessionRequestCapability> getQueueContents();

    @Override
    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

