/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_41;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.Set;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.internal.ImageSummary;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.docker.v1_41.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ListImages {
    private static final Json JSON = new Json();
    private static final Type SET_OF_IMAGE_SUMMARIES = new TypeToken<Set<ImageSummary>>(){}.getType();
    private final HttpHandler client;

    public ListImages(HttpHandler client) {
        this.client = Require.nonNull("HTTP client", client);
    }

    public Set<Image> apply(Reference reference) {
        Require.nonNull("Reference to search for", reference);
        String familiarName = reference.getFamiliarName();
        ImmutableMap<String, ImmutableMap<String, Boolean>> filters = ImmutableMap.of("reference", ImmutableMap.of(familiarName, true));
        HttpRequest req = ((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v%s/images/json", "1.41")).addHeader("Content-Length", "0")).addHeader("Content-Type", "application/json; charset=utf-8")).addQueryParameter("filters", JSON.toJson(filters));
        HttpResponse response = DockerMessages.throwIfNecessary(this.client.execute(req), "Unable to list images for %s", reference);
        Set images = (Set)JSON.toType(Contents.string(response), SET_OF_IMAGE_SUMMARIES);
        return images.stream().map(Image::new).collect(ImmutableSet.toImmutableSet());
    }
}

