/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.overlay.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ColorFormat {
    RGB("rgb"),
    HSL("hsl"),
    HEX("hex");

    private String value;

    private ColorFormat(String value) {
        this.value = value;
    }

    public static ColorFormat fromString(String s2) {
        return Arrays.stream(ColorFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ColorFormat "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ColorFormat fromJson(JsonInput input) {
        return ColorFormat.fromString(input.nextString());
    }
}

