/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class SystemOutLogExporter
implements LogExporter {
    private static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ISO_DATE_TIME;

    @Override
    public CompletableResultCode export(Collection<LogData> logs) {
        StringBuilder stringBuilder = new StringBuilder(60);
        for (LogData log : logs) {
            stringBuilder.setLength(0);
            SystemOutLogExporter.formatLog(stringBuilder, log);
            System.out.println(stringBuilder);
        }
        return CompletableResultCode.ofSuccess();
    }

    static void formatLog(StringBuilder stringBuilder, LogData log) {
        InstrumentationLibraryInfo instrumentationLibraryInfo = log.getInstrumentationLibraryInfo();
        stringBuilder.append(ISO_FORMAT.format(Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(log.getEpochNanos())).atZone(ZoneOffset.UTC))).append(" ").append((Object)log.getSeverity()).append(" '").append(log.getBody().asString()).append("' : ").append(log.getSpanContext().getTraceId()).append(" ").append(log.getSpanContext().getSpanId()).append(" [libraryInfo: ").append(instrumentationLibraryInfo.getName()).append(":").append(instrumentationLibraryInfo.getVersion() == null ? "" : instrumentationLibraryInfo.getVersion()).append("] ").append(log.getAttributes());
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

