/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.PublicApi;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public class MultiSourceReader
extends Reader {
    private final List<SourcePart> sourceParts;
    private final StringBuilder data = new StringBuilder();
    private int currentIndex = 0;
    private int overallLineNumber = 0;
    private final boolean trackData;

    private MultiSourceReader(Builder builder) {
        this.sourceParts = builder.sourceParts;
        this.trackData = builder.trackData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        while (true) {
            MultiSourceReader multiSourceReader = this;
            synchronized (multiSourceReader) {
                if (this.currentIndex >= this.sourceParts.size()) {
                    return -1;
                }
                SourcePart sourcePart = this.sourceParts.get(this.currentIndex);
                int read = sourcePart.lineReader.read(cbuf, off, len);
                this.overallLineNumber = this.calcLineNumber();
                if (read == -1) {
                    ++this.currentIndex;
                } else {
                    this.trackData(cbuf, off, read);
                    return read;
                }
            }
        }
    }

    private void trackData(char[] cbuf, int off, int len) {
        if (this.trackData) {
            this.data.append(cbuf, off, len);
        }
    }

    private int calcLineNumber() {
        int linenumber = 0;
        for (SourcePart sourcePart : this.sourceParts) {
            linenumber += sourcePart.lineReader.getLineNumber();
        }
        return linenumber;
    }

    public SourceAndLine getSourceAndLineFromOverallLine(int overallLineNumber) {
        SourceAndLine sourceAndLine = new SourceAndLine();
        if (this.sourceParts.isEmpty()) {
            return sourceAndLine;
        }
        if (overallLineNumber == 0) {
            sourceAndLine.sourceName = this.sourceParts.get((int)0).sourceName;
            sourceAndLine.line = 0;
            return sourceAndLine;
        }
        SourcePart currentPart = this.currentIndex >= this.sourceParts.size() ? this.sourceParts.get(this.sourceParts.size() - 1) : this.sourceParts.get(this.currentIndex);
        int page = 0;
        for (SourcePart sourcePart : this.sourceParts) {
            int previousPage;
            int partLineNumber;
            sourceAndLine.sourceName = sourcePart.sourceName;
            if (sourcePart == currentPart) {
                partLineNumber = currentPart.lineReader.getLineNumber();
                previousPage = page;
                if ((page += partLineNumber) > overallLineNumber) {
                    sourceAndLine.line = overallLineNumber - previousPage;
                } else {
                    sourceAndLine.line = page;
                }
                return sourceAndLine;
            }
            previousPage = page;
            partLineNumber = sourcePart.lineReader.getLineNumber();
            if ((page += partLineNumber) <= overallLineNumber) continue;
            sourceAndLine.line = overallLineNumber - previousPage;
            return sourceAndLine;
        }
        sourceAndLine.line = overallLineNumber - page;
        return sourceAndLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() {
        MultiSourceReader multiSourceReader = this;
        synchronized (multiSourceReader) {
            if (this.sourceParts.isEmpty()) {
                return 0;
            }
            if (this.currentIndex >= this.sourceParts.size()) {
                return this.sourceParts.get((int)(this.sourceParts.size() - 1)).lineReader.getLineNumber();
            }
            return this.sourceParts.get((int)this.currentIndex).lineReader.getLineNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceName() {
        MultiSourceReader multiSourceReader = this;
        synchronized (multiSourceReader) {
            if (this.sourceParts.isEmpty()) {
                return null;
            }
            if (this.currentIndex >= this.sourceParts.size()) {
                return this.sourceParts.get((int)(this.sourceParts.size() - 1)).sourceName;
            }
            return this.sourceParts.get((int)this.currentIndex).sourceName;
        }
    }

    public int getOverallLineNumber() {
        return this.overallLineNumber;
    }

    public List<String> getData() {
        LineNumberReader reader = new LineNumberReader(new StringReader(this.data.toString()));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return lines;
                }
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MultiSourceReader multiSourceReader = this;
        synchronized (multiSourceReader) {
            for (SourcePart sourcePart : this.sourceParts) {
                if (sourcePart.closed) continue;
                sourcePart.lineReader.close();
                sourcePart.closed = true;
            }
        }
    }

    public static Builder newMultiSourceReader() {
        return new Builder();
    }

    public static class Builder {
        List<SourcePart> sourceParts = new ArrayList<SourcePart>();
        boolean trackData = true;

        private Builder() {
        }

        public Builder reader(Reader reader, String sourceName) {
            SourcePart sourcePart = new SourcePart();
            sourcePart.lineReader = new LineNumberReader(Assert.assertNotNull(reader));
            sourcePart.sourceName = sourceName;
            sourcePart.closed = false;
            this.sourceParts.add(sourcePart);
            return this;
        }

        public Builder string(String input, String sourceName) {
            SourcePart sourcePart = new SourcePart();
            sourcePart.lineReader = new LineNumberReader(new StringReader(input));
            sourcePart.sourceName = sourceName;
            sourcePart.closed = false;
            this.sourceParts.add(sourcePart);
            return this;
        }

        public Builder trackData(boolean trackData) {
            this.trackData = trackData;
            return this;
        }

        public MultiSourceReader build() {
            return new MultiSourceReader(this);
        }
    }

    private static class SourcePart {
        String sourceName;
        LineNumberReader lineReader;
        boolean closed;

        private SourcePart() {
        }
    }

    public static class SourceAndLine {
        private String sourceName = null;
        private int line = 0;

        public String getSourceName() {
            return this.sourceName;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return "SourceAndLine{sourceName='" + this.sourceName + '\'' + ", line=" + this.line + '}';
        }
    }
}

