/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.language.AstPrinter;
import graphql.language.Value;
import java.util.Objects;

public class NormalizedInputValue {
    private final String typeName;
    private final Object value;

    public NormalizedInputValue(String typeName, Object value) {
        this.typeName = typeName;
        this.value = value;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isList() {
        return this.typeName.startsWith("[");
    }

    public String getUnwrappedTypeName() {
        String result = this.unwrapNonNull(this.typeName);
        while (result.startsWith("[")) {
            result = result.substring(1, result.length() - 2);
            result = this.unwrapNonNull(result);
        }
        return result;
    }

    private String unwrapNonNull(String string) {
        return string.endsWith("!") ? string.substring(0, string.length() - 2) : string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NormalizedInputValue that = (NormalizedInputValue)o;
        if (this.value instanceof Value && that.value instanceof Value) {
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(AstPrinter.printAst((Value)this.value), AstPrinter.printAst((Value)that.value));
        }
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.value);
    }

    public String toString() {
        return "NormalizedInputValue{typeName='" + this.typeName + '\'' + ", value=" + this.value + '}';
    }
}

