/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.IgnoredChars;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.SourceLocation;
import graphql.language.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class InterfaceTypeExtensionDefinition
extends InterfaceTypeDefinition {
    @Internal
    protected InterfaceTypeExtensionDefinition(String name, List<Type> implementz, List<FieldDefinition> definitions, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(name, implementz, definitions, directives, description, sourceLocation, comments, ignoredChars, additionalData);
    }

    @Override
    public InterfaceTypeExtensionDefinition deepCopy() {
        return new InterfaceTypeExtensionDefinition(this.getName(), this.getImplements(), this.deepCopy(this.getFieldDefinitions()), this.deepCopy(this.getDirectives()), this.getDescription(), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    @Override
    public String toString() {
        return "InterfaceTypeExtensionDefinition{name='" + this.getName() + '\'' + ", fieldDefinitions=" + this.getFieldDefinitions() + ", directives=" + this.getDirectives() + '}';
    }

    public static Builder newInterfaceTypeExtensionDefinition() {
        return new Builder();
    }

    @Override
    public InterfaceTypeExtensionDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transformExtension(builder -> builder.definitions(newChildren.getChildren("definitions")).directives(newChildren.getChildren("directives")));
    }

    public InterfaceTypeExtensionDefinition transformExtension(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Description description;
        private ImmutableList<Type> implementz = ImmutableKit.emptyList();
        private ImmutableList<FieldDefinition> definitions = ImmutableKit.emptyList();
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(InterfaceTypeExtensionDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.implementz = ImmutableList.copyOf(existing.getImplements());
            this.definitions = ImmutableList.copyOf(existing.getFieldDefinitions());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder implementz(List<Type> implementz) {
            this.implementz = ImmutableList.copyOf(implementz);
            return this;
        }

        public Builder implementz(Type implementz) {
            this.implementz = ImmutableKit.addToList(this.implementz, implementz, new Type[0]);
            return this;
        }

        public Builder definitions(List<FieldDefinition> definitions) {
            this.definitions = ImmutableList.copyOf(definitions);
            return this;
        }

        public Builder definition(FieldDefinition definition) {
            this.definitions = ImmutableKit.addToList(this.definitions, definition, new FieldDefinition[0]);
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public InterfaceTypeExtensionDefinition build() {
            return new InterfaceTypeExtensionDefinition(this.name, this.implementz, this.definitions, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

