/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.AbstractAsyncExecutionStrategy;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

@PublicApi
public class AsyncExecutionStrategy
extends AbstractAsyncExecutionStrategy {
    public AsyncExecutionStrategy() {
        super(new SimpleDataFetcherExceptionHandler());
    }

    public AsyncExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        ExecutionStrategyInstrumentationContext executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        MergedSelectionSet fields = parameters.getFields();
        Set<String> fieldNames = fields.keySet();
        ArrayList futures = new ArrayList(fieldNames.size());
        ArrayList<String> resolvedFields = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            MergedField currentField = fields.getSubField(fieldName);
            ResultPath fieldPath = parameters.getPath().segment(AsyncExecutionStrategy.mkNameForPath(currentField));
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.field(currentField).path(fieldPath).parent(parameters));
            resolvedFields.add(fieldName);
            CompletableFuture<FieldValueInfo> future = this.resolveFieldWithInfo(executionContext, newParameters);
            futures.add(future);
        }
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        executionStrategyCtx.onDispatched(overallResult);
        ((CompletableFuture)Async.each(futures).whenComplete((completeValueInfos, throwable) -> {
            BiConsumer<List<ExecutionResult>, Throwable> handleResultsConsumer = this.handleResults(executionContext, resolvedFields, overallResult);
            if (throwable != null) {
                handleResultsConsumer.accept(null, throwable.getCause());
                return;
            }
            ImmutableList executionResultFuture = ImmutableKit.map(completeValueInfos, FieldValueInfo::getFieldValue);
            executionStrategyCtx.onFieldValuesInfo((List<FieldValueInfo>)completeValueInfos);
            Async.each(executionResultFuture).whenComplete(handleResultsConsumer);
        })).exceptionally(ex -> {
            executionStrategyCtx.onFieldValuesException();
            overallResult.completeExceptionally((Throwable)ex);
            return null;
        });
        overallResult.whenComplete(executionStrategyCtx::onCompleted);
        return overallResult;
    }
}

