import argparse
import tensorflow as tf
import numpy as np

parser = argparse.ArgumentParser()

##### Argumenty ####

## Parametry zbioru Fashion MNIST
N_CLASSES = 10
IMG_WIDTH = 28
IMG_HEIGHT = 28
N_CHANNELS = 1                 # Liczba kanałów wejściowych
IMAGE_LABELS = ['T-shirt/top', 'Trouser', 'Pullover', 'Dress', 'Coat',
                            'Sandal', 'Shirt', 'Sneaker', 'Bag', 'Ankle boot']



## Parametry modelu
CONV1_LAYER_PARAMS =  {"filters": 256,
                "kernel_size": 9,
                "activation": tf.nn.relu,
                "padding": "valid",
                "strides": 1
                }

# Parametry warstwy kapsuł podstawowych
MAPS_CAPS1 = 32
NCAPS_CAPS1 = MAPS_CAPS1*6*6  # Ogólna liczba kapsuł podstawowych = 1152
CAPS_DIM_CAPS1 = 8            # Wymiary każdej kapsuły

CONV2_LAYER_PARAMS  = {"filters": MAPS_CAPS1 * CAPS_DIM_CAPS1,  # Ogólna liczba filtrów splotowych = 256
                "kernel_size": 9,
                "strides": 2,
                "padding": "valid",
                "activation": tf.nn.relu}

# Parametry warstwy kapsuł cyfrowych
NCAPS_CAPS2 = 10
CAPS_DIM_CAPS2 = 16           # Wymiar każdej kapsuły w warstwie 2.

# Parametry dekodera
layer1_size = 512
layer2_size = 1024
output_size = IMG_WIDTH* IMG_HEIGHT

## Strata

# Strata marginesu
M_PLUS = 0.9
M_MINUS= 0.1
LAMBDA = 0.5

# Strata rekonstrukcji
ALPHA = 0.0005

# Parametry szkolenia
BATCH_SIZE = 128
EPOCHS = 20
ROUTING_ITERATIONS = 3    # Iteracje trasowania
STDEV = 0.01  # Odchylenie standardowe dla inicjalizacji wag


## Katalogi środowiska i zapisu
RESTORE_TRAINING = False            # Odtwarzanie wyszkolonego modelu
CHECKPOINT_PATH_DIR = './model_dir'
LOG_DIR = './logs/'
RESULTS_DIR = './results/'
STEPS_TO_SAVE = 100                 # Czestotliwość (w krokach) zapisu wyników szkolenia

## Parametry wizualizacji
N_SAMPLES = 3                       # Liczba próbek obrazów do zapisu



