﻿using System;
using System.Collections.Generic;
using Xunit;

namespace MastermindGame.Tests
{
    public class GoldStandardTests
    {
        [Fact]
        public void StandardTestRun()
        {
            // Arrange
            var inout = new MockInputOutput();
            var rand = new MockRandomGenerator();
            var game = new Mastermind(inout, rand);

            // Arrange - Dane wejściowe
            rand.SetLetters('A', 'B', 'C', 'F');
            inout.InFeed.Enqueue("AAA");
            inout.InFeed.Enqueue("AAAA");
            inout.InFeed.Enqueue("ABBB");
            inout.InFeed.Enqueue("ABCC");
            inout.InFeed.Enqueue("ABCD");
            inout.InFeed.Enqueue("ABCF");
            inout.InFeed.Enqueue(" ");

            // Arrange - Dane wyjściowe
            var expectedOutputs = new Queue<string>();
            expectedOutputs.Enqueue("Zgadnij: ");
            expectedOutputs.Enqueue("Długość hasła to 4." + Environment.NewLine);
            expectedOutputs.Enqueue("Zgadnij: ");
            expectedOutputs.Enqueue("+---" + Environment.NewLine);
            expectedOutputs.Enqueue("Zgadnij: ");
            expectedOutputs.Enqueue("++--" + Environment.NewLine);
            expectedOutputs.Enqueue("Zgadnij: ");
            expectedOutputs.Enqueue("+++-" + Environment.NewLine);
            expectedOutputs.Enqueue("Zgadnij: ");
            expectedOutputs.Enqueue("+++" + Environment.NewLine);
            expectedOutputs.Enqueue("Zgadnij: ");
            expectedOutputs.Enqueue("++++" + Environment.NewLine);
            expectedOutputs.Enqueue("Gratulacje, odgadłeś hasło w 6 próbie." + Environment.NewLine);

            // Act
            game.Play();

            // Assert
            inout.OutFeed.ForEach(text =>
            {
                Assert.Equal(expectedOutputs.Dequeue(), text);
            });
        }
    }
}
