﻿using System.Linq;
using Xunit;

namespace ToDoApp.Tests
{
    public class TodoListCompleteTests
    {
        [Fact]
        public void ItHidesAnItemFromTheList()
        {
            // Arrange
            var todo = new TodoList();
            var item = new Todo { Description = "Testowe zadanie" };
            todo.AddTodo(item);
            // Act
            todo.Complete(item);
            // Assert
            Assert.Equal(0, todo.Items.Count());
        }
        [Fact]
        public void ItMarksAnItemComplete()
        {
            // Arrange
            var todo = new TodoList();
            var item = new Todo { Description = "Testowe zadanie" };
            todo.AddTodo(item);
            // Act
            todo.Complete(item);
            // Assert
            Assert.True(item.IsComplete);
        }
        [Fact]
        public void ItShowsCompletedItems()
        {
            // Arrange
            var todo = new TodoList();
            var item = new Todo { Description = "Testowe zadanie" };
            todo.ShowCompleted = true;
            todo.AddTodo(item);
            // Act
            todo.Complete(item);
            // Assert
            Assert.Equal(1, todo.Items.Count());
        }
    }
}
