import { expect } from 'chai';
import React from 'react';
import { mount } from 'enzyme';
import { SpeakerDetailPage } from './SpeakerDetailPage';

describe('Strona szczegółów prelegenta', () => {
  it('istnieje', () => {
    expect(SpeakerDetailPage).to.exist;
  });

  describe('Render', () => {
    it('renderuje', () => {
      // arrange
      const props = {
        match: { params: { id: 'testowy-prelegent' } },
        actions: {
          getSpeaker: id => {
            return Promise.resolve();
          }
        },
        speaker: { firstName: 'Testowy' }
      };

      // act
      const component = mount(<SpeakerDetailPage {...props} />);

      // assert
      expect(component.find('#first-name').text()).to.contain('Testowy');
    });
  });
});
