﻿using System.Security.Cryptography;
using System.Text;
using SpeakerMeet.Services.Tests;
using Xunit;

namespace SpeakerMeet.Business.Tests.AccountTests
{
    public class LogonTests
    {
        private readonly string _accessKey;
        private readonly Account _account;

        public LogonTests()
        {
            _accessKey = "UdzielonyKluczDostepowy";
            var repository = new FakeRepository<UserCredentials>();
            _account = new AccountTestDouble(repository);

            repository.DataSet.Add(new UserCredentials
            {
                Username = "PoprawnyUzytkownik@email.com",
                PasswordHash = SHA512.Create().ComputeHash(Encoding.ASCII.GetBytes("PoprawneHaslo"))
            });
        }

        [Fact]
        public void GivenAnInvalidUsername()
        {
            // Arrange/Zakładając
            var username = "NiepoprawnyUzytkownik@email.com";
            var password = "NieistotnePassword";

            // Act/Kiedy
            var exception = Record.Exception(() => _account.Logon(username, password));

            // Assert/Wtedy
            Assert.IsAssignableFrom<InvalidUsernameOrPasswordException>(exception);
            Assert.Equal("Niepoprawna nazwa użytkownika lub hasło", exception.Message);
        }

        [Fact]
        public void GivenAValidUsernameAndPassword()
        {
            // Arrange/Zakładając
            var username = "PoprawnyUzytkownik@email.com";
            var password = "PoprawneHaslo";

            // Act/Kiedy
            var result = _account.Logon(username, password);

            // Assert/Wtedy
            Assert.IsAssignableFrom<string>(result);
            Assert.Equal(_accessKey, result);
        }

        [Fact]
        public void GivenAnInvalidPassword()
        {
            // Arrange/Zakładając
            var username = "PoprawnyUzytkownik@email.com";
            var password = "NiepoprawneHaslo";

            // Act/Kiedy
            var exception = Record.Exception(() => _account.Logon(username, password));

            // Assert/Wtedy
            Assert.IsAssignableFrom<InvalidUsernameOrPasswordException>(exception);
            Assert.Equal("Niepoprawna nazwa użytkownika lub hasło", exception.Message);
        }
    }
}
