import { expect } from 'chai';
import { errorReducer } from './errorReducer';
import * as errorTypes from './errorTypes';
import * as actions from '../actions/speakerActions';


describe('Reduktor błędów', () => {
  it('istnieje', () => {
    expect(errorReducer).to.exist;
  });

  it('zwraca stan błędów', () => {
    // arrange
    const initialState = [];
    const error = { type: errorTypes.SPEAKER_NOT_FOUND };
    const action = actions.getSpeakerFailure(error);
  
    // act
    const newState = errorReducer(initialState, action);
  
    // assert
    expect(newState).to.deep.equal([error]);
  });

  it('ignoruje duplikaty błędów', () => {
    // arrange
    const error = { type: errorTypes.SPEAKER_NOT_FOUND };
    const initialState = [error];
    const action = actions.getSpeakerFailure(error);
  
    // act
    const newState = errorReducer(initialState, action);
  
    // assert
    expect(newState).to.deep.equal([error]);
  });

  it('czyści stan, kiedy otrzymana zostanie akcja niebędąca błędem', () => {
    // arrange
    const error = { type: errorTypes.SPEAKER_NOT_FOUND };
    const initialState = [error];
    const action = { type: 'DOWOLNY_NIE_BLAD' };
  
    // act
    const newState = errorReducer(initialState, action);
  
    // assert
    expect(newState).to.deep.equal([]);
  });
});
