﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using SpeakerMeet.Repositories.Interfaces;

namespace SpeakerMeet.Services.Tests
{
    public class FakeRepository<T> : IRepository<T> where T : IIdentity
    {
        private int _identityCounter;
        public IList<T> DataSet { get; set; } = new List<T>();

        public T Get(int id)
        {
            throw new NotImplementedException();
        }

        public T Get(Func<T, bool> predicate)
        {
            return GetAll().Where(predicate).FirstOrDefault();
        }

        public IQueryable<T> GetAll()
        {
            return DataSet.AsQueryable();
        }

        public T Save(T item)
        {
            return item.Id == default(int) ? Create(item) : Update(item);
        }

        public IRepository<T> Include(Expression<Func<T, object>> path)
        {
            // Tutaj nie ma nic do zrobienia, ponieważ jest to funkcja na potrzeby EntityFramework
            // Używamy Linq to Objects, nie ma więc potrzeby wykorzystania tej funkcji
            return this;
        }

        private T Create(T item)
        {
            item.Id = ++_identityCounter;
            DataSet.Add(item);
            return item;
        }

        private T Update(T item)
        {
            var found = Get(x => x.Id == item.Id);

            if (found == null)
            {
                throw new KeyNotFoundException($"Element o Id {item.Id} nie został znaleziony!");
            }

            DataSet.Remove(found);
            DataSet.Add(item);

            return item;
        }
    }
}
