import { expect } from 'chai';
import React from 'react';
import { shallow } from 'enzyme';
import { SpeakerList } from './SpeakerList';

describe('Lista prelegentów', () => {
  it('istnieje', () => {
    expect(SpeakerList).to.exist;
  });

  describe('Podczas renderowania', () => {
    describe('Nie ma prelegentów', () => {
      it('renderuje informację o branku prelegentów', () => {
        // arrange
        const speakers = [];

        // arrange
        const component = setup({ speakers })

        // assert
        expect(component.find('#no-speakers').text()).to.equal('Brak prelegentów.');
      });
    });

    describe('Prelegenci istnieją', () => {
        it('renderuje tabele, kiedy prelegenci istnieją', () => {
          // arrange
          const speakers = [{
              id: 'testowy-prelegent-1',
              firstName: 'Testowy',
              lastName: 'Prelegent 1'
          }, {
              id: 'testowy-prelegent-2',
              firstName: 'Testowy',
              lastName: 'Prelegent 2'
          }];
      
          // act
          const component = setup({speakers});
      
          // assert        
          expect(component.find('.speakers').children()).to.have.lengthOf(2);
          expect(component.find('.speakers').childAt(0).type().name).to.equal('SpeakerListRow');
        });
      });
  });
});

function setup(props) {
  const componentProps = {
    speakers: props.speakers || []
  };

  return shallow(<SpeakerList {...componentProps} />);
}
