import React from 'react';
import { expect } from 'chai';
import { mount, shallow } from 'enzyme';
import { SpeakersPage } from './SpeakersPage';

describe('Strona prelegentów', () => {
  it('istnieje', () => {
    expect(SpeakersPage).to.exist;
  });

  describe('Renderowanie', () => {
    beforeEach(() => {});

    it('renderuje', () => {
      // arrange
      const props = {
        speakers: [
          {
            id: 'testowy-prelegent',
            firstName:'Testowy',
            lastName:'Prelegent'
          }
        ]
      };

      // act
      const component = shallow(<SpeakersPage {...props} />);

      // assert
      expect(component.find('SpeakerList')).to.exist;
      expect(component.find('SpeakerList').props().speakers).to.deep.equal(props.speakers);
    });
  });  
});
