import { expect } from 'chai';
import { MockSpeakerService } from './mockSpeakerService';
import factory from './serviceFactory';
 
describe('Fabryka usługi', () => {
  it('istnieje', () => {
    expect(factory).to.exist;
  });

  describe('Tworzenie usługi prelegentów', () => {
    it('istnieje', () => {
      expect(factory.createSpeakerService).to.exist;
    });
  });

  it('zwraca usługę prelegentów', () => {
    // act
    let result = factory.createSpeakerService();
  
    // assert
    expect(result).to.be.an.instanceof(MockSpeakerService);
  });

  it('zwraca tę samą usługę prelegentów', () => {
    // act
    let service1 = factory.createSpeakerService();
    let service2 = factory.createSpeakerService();
  
    // assert
    expect(service1).to.equal(service2);
  });
});
