import { expect } from 'chai';
import * as errorTypes from '../reducers/errorTypes';
import { MockSpeakerService } from '../services/mockSpeakerService';

describe('Imitacja usługi prelegenta', () => {
  it('istnieje', () => {
    expect(MockSpeakerService).to.exist;
  });

  it('może być skonstruowany', () => {
    // arrange
    let service = new MockSpeakerService();

    // assert
    expect(service).to.be.an.instanceof(MockSpeakerService);
  });

  describe('Po inicjalizacji', () => {
    let service = null;

    beforeEach(() => {
      service = new MockSpeakerService();
    });

    describe('Create', () => {
      it('istnieje', () => {
        expect(service.create).to.exist;
      });
    });

    describe('getAll', () => {
      it('istnieje', () => {
        // assert
        expect(service.getAll).to.exist;
      });

      describe('Żaden prelegent nie istnie', () => {
        it('zwraca pustą tablicę', () => {
          // act
          let promise = service.getAll();

          // assert
          return promise.then(result => {
            expect(result).to.have.lengthOf(0);
          });
        });
      });

      describe('Listing prelegentów', () => {
        it('zwraca prelegentów', () => {
          // arrange
          service.create({});

          // act
          let promise = service.getAll();

          // assert
          return promise.then(result => {
            expect(result).to.have.lengthOf(1);
          });
        });
      });
    });

    describe('Pobierz prelegenta po Id', () => {
      it('istnieje', () => {
        // assert
        expect(service.getById).to.exist;
      });

      describe('Prelegent nie istnieje', () => {
        it('generowany jest błąd SPEAKER_NOT_FOUND', () => {
          // act
          const promise = service.getById('nieistniejacy-prelegent');

          // assert
          return promise.catch(error => {
            expect(error.type).to.equal(errorTypes.SPEAKER_NOT_FOUND);
          });
        });
      });

      describe('Prelegent istnieje', () => {
        it('zwraca prelegenta', () => {
          // arrange
          const speaker = { id: 'testowy-prelegent' };
          service.create(speaker);
      
          // act
          let promise = service.getById('testowy-prelegent');
      
          // assert
          return promise.then((speaker) => {
            expect(speaker).to.not.be.null;
            expect(speaker.id).to.equal('testowy-prelegent');
          });
        });
      });
    });
  });
});
