﻿using Microsoft.EntityFrameworkCore;
using SpeakerMeet.DTO;
using SpeakerMeet.Models;
using SpeakerMeet.Repositories;
using SpeakerMeet.Repositories.Interfaces;
using SpeakerMeet.Services;
using SpeakerMeet.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Text;
using Xunit;

namespace SpeakerMeet.Api.IntegrationTest.GetAll2
{
    [Collection("Service")]
    [Trait("Category", "Integration")]
    public class GetAll : IClassFixture<ContextFixture>
    {
        private readonly IRepository<Models.Speaker> _repository;
        private readonly IGravatarService _gravatarService;
        public GetAll(ContextFixture fixture)
        {
            _repository = new Repository<Models.Speaker>(fixture.Context);
            _gravatarService = new GravatarService();
        }
        [Fact]
        public void ItExists()
        {
            var speakerService = new SpeakerService(_repository, _gravatarService);
        }

        [Fact]
        public void ItReturnsCollectionOfSpeakerSummary()
        {
            // Arrange
            var speakerService = new SpeakerService(_repository, _gravatarService);
        
            // Act
            var speakers = speakerService.GetAll();
            
            // Assert
            Assert.NotNull(speakers);
            Assert.IsAssignableFrom<IEnumerable<SpeakerSummary>>(speakers);
        }
    }
}
