using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using SpeakerMeet.API.Controllers;
using Xunit;

namespace SpeakerMeet.API.Tests
{
    public class SpeakerControllerSearchTests
    {
        private readonly SpeakerController _controller;

        public SpeakerControllerSearchTests()
        {
            _controller = new SpeakerController();
        }

        [Fact(Skip="Ju niepotrzebny")]
        public void ItExists()
        {
            var controller = new SpeakerController();
        }

        [Fact(Skip = "Ju niepotrzebny")]
        public void ItHasSearch()
        {
            // Arrange
            var controller = new SpeakerController();

            // Act
            controller.Search("Jan");
        }

        [Fact(Skip = "Ju niepotrzebny")]
        public void ItReturnsOkObjectResult()
        {
            // Arrange
            var controller = new SpeakerController();

            // Act
            var result = controller.Search("Jan");

            // Assert
            Assert.NotNull(result);
            Assert.IsType<OkObjectResult>(result);
        }

        [Fact]
        public void ItReturnsCollectionOfSpeakers()
        {
            // Arrange
            var controller = new SpeakerController();

            // Act
            var result = controller.Search("Jan") as OkObjectResult;

            // Assert
            Assert.NotNull(result);
            Assert.NotNull(result.Value);
            Assert.IsType<List<Speaker>>(result.Value);
        }

        [Fact]
        public void GivenExactMatchThenOneSpeakerInCollection()
        {
            // Arrange
            // Act
            var result = _controller.Search("Janusz") as OkObjectResult;

            // Assert  
            var speakers = ((IEnumerable<Speaker>)result.Value).ToList();
            Assert.Equal(1, speakers.Count);
            Assert.Equal("Janusz", speakers[0].Name);
        }

        [Theory]
        [InlineData("Janusz")]
        [InlineData("janusz")]
        [InlineData("JaNuSz")]
        public void GivenCaseInsensitveMatchThenSpeakerInCollection(string searchString)
        {
            // Arrange
            // Act
            var result = _controller.Search(searchString) as OkObjectResult;

            // Assert
            var speakers = ((IEnumerable<Speaker>)result.Value).ToList();
            Assert.Equal(1, speakers.Count);
            Assert.Equal("Janusz", speakers[0].Name);
        }

        [Fact]
        public void GivenNoMatchThenEmptyCollection()
        {
            // Arrange
            // Act
            var result = _controller.Search("ZZZ") as OkObjectResult;

            // Assert
            var speakers = ((IEnumerable<Speaker>)result.Value).ToList();
            Assert.Equal(0, speakers.Count);
        }

        [Fact]
        public void Given3MatchThenCollectionWith3Speakers()
        {
            // Arrange
            // Act 
            var result = _controller.Search("jan") as OkObjectResult;

            // Assert  
            var speakers = ((IEnumerable<Speaker>)result.Value).ToList();
            Assert.Equal(3, speakers.Count);
            Assert.True(speakers.Any(s => s.Name == "Jan"));
            Assert.True(speakers.Any(s => s.Name == "Janusz"));
            Assert.True(speakers.Any(s => s.Name == "Janina"));
        }
    }
}
