from .base import FunctionalTest


class MyListsTest(FunctionalTest):

    def test_logged_in_users_lists_are_saved_as_my_lists(self):
        # Edyta jest zalogowanym użytkownikiem.
        self.create_pre_authenticated_session('edyta@przyklad.pl')

        # Przeszła na stronę główną i zaczęła tworzyć nową listę.
        self.browser.get(self.server_url)
        self.get_item_input_box().send_keys('Przygotować siatkę\n')
        self.get_item_input_box().send_keys('Kupić przynętę\n')
        first_list_url = self.browser.current_url

        # Po raz pierwszy zauważyła łącze "Moje listy".
        self.browser.find_element_by_link_text('Moje listy').click()

        # Zobaczyła, że jej lista tam się znajduje.
        # Nazwa listy pochodzi od pierwszego elementu na niej.
        self.browser.find_element_by_link_text('Przygotować siatkę').click()
        self.wait_for(
            lambda: self.assertEqual(self.browser.current_url, first_list_url)
        )

        # Postanowiła utworzyć kolejną listę.
        self.browser.get(self.server_url)
        self.get_item_input_box().send_keys('Przygotowania do wyprawy\n')
        second_list_url = self.browser.current_url

        # Strona "Moje listy" zawierała teraz tę nową listę.
        self.browser.find_element_by_link_text('Moje listy').click()
        self.browser.find_element_by_link_text('Przygotowania do wyprawy').click()
        self.assertEqual(self.browser.current_url, second_list_url)

        # Wylogowała się. Opcja "Moje listy" zniknęła.
        self.browser.find_element_by_id('id_logout').click()
        self.assertEqual(
            self.browser.find_elements_by_link_text('Moje listy'),
            []
        )

