from selenium import webdriver
from .base import FunctionalTest
from .home_and_list_pages import HomePage


def quit_if_possible(browser):
    try: browser.quit()
    except: pass


class SharingTest(FunctionalTest):

    def test_logged_in_users_lists_are_saved_as_my_lists(self):
        # Edyta jest zalogowanym użytkownikiem.
        self.create_pre_authenticated_session('edyta@przyklad.pl')
        edith_browser = self.browser
        self.addCleanup(lambda: quit_if_possible(edith_browser))

        # Jej przyjaciel Orfeusz również korzysta z witryny.
        oni_browser = webdriver.Firefox()
        self.addCleanup(lambda: quit_if_possible(oni_browser))
        self.browser = oni_browser
        self.create_pre_authenticated_session('orfeusz@przyklad.pl')

        # Edyta przeszła na stronę główną i zaczyna tworzyć listę.
        self.browser = edith_browser
        list_page = HomePage(self).start_new_list('Pomoc')

        # Zauważa opcję "Udostępnij tę listę".
        share_box = list_page.get_share_box()
        self.assertEqual(
            share_box.get_attribute('placeholder'),
            'twoj-przyjaciel@przyklad.pl'
        )

        # Edyta udostępnia swoją listę.
        # Strona zostaje uaktualniona i informuje o udostępnieniu listy Orfeuszowi.
        list_page.share_list_with('orfeusz@przyklad.pl')

        # W przeglądarce internetowej Orfeusz przechodzi na stronę list.
        self.browser = oni_browser
        HomePage(self).go_to_home_page().go_to_my_lists_page()

        # Widzi tam listę udostępnioną przez Edytę!
        self.browser.find_element_by_link_text('Pomoc').click()

        # Na stronie listy Orfeusz widzi, że to jest lista Edyty.
        self.wait_for(lambda: self.assertEqual(
            list_page.get_list_owner(),
            'edyta@przyklad.pl'
        ))

        # Dodaje element do listy.
        list_page.add_new_item('Witaj, Edyto!')

        # Kiedy Edyta odświeży stronę, widzi element dodany przez Orfeusza.
        self.browser = edith_browser
        self.browser.refresh()
        list_page.wait_for_new_item_in_list('Witaj, Edyto!', 2)

