package com.packtpublishing.tddjava.ch02friendships.bdd.steps;

// Umieść w komentarzu przy wykonywaniu testów JBehave
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
// Koniec komentarza

/* Usuń komentarz przy wykonywaniu testów JBehave
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
*/

import org.openqa.selenium.By;

import static com.codeborne.selenide.Selenide.*;
import static org.hamcrest.CoreMatchers.containsString;
import static org.junit.Assert.assertThat;

public class WebSteps {
    // Umieść w komentarzu przy wykonywaniu testów JBehave
    @Given("^: Przechodze do strony glownej Wikipedii$")
    @org.jbehave.core.annotations.Given(": Przechodze do strony glownej Wikipedii")
    public void przechodze_do_strony_glownej_Wikipedii() {
        open("http://en.wikipedia.org/wiki/Main_Page");
    }

    @When("^: Wprowadzam wartosc (.*) w polu o nazwie (.*)$")
    @org.jbehave.core.annotations.When(": Wprowadzam wartosc $value w polu o nazwie $fieldName")
    public void wprowadzam_wartosc_Test_driven_development_w_polu_o_nazwie_search(String value, String fieldName){
        $(By.name(fieldName)).setValue(value);
    }

    @When("^: Klikam przycisk (.*)$")
    @org.jbehave.core.annotations.When(": Klikam przycisk $buttonName")
    public void klikam_przycisk_go(String buttonName){
        $(By.name(buttonName)).click();
    }

    @Then("^: Tytul strony zawiera czlon (.*)$")
    @org.jbehave.core.annotations.Then(": Tytul strony zawiera czlon $title")
    public void tytul_strony_zawiera_czlon_Test_driven_development(String title) {
        assertThat(title(), containsString(title));
    }
    // Koniec komentarza

    /* Usuń komentarz przy wykonywaniu testów JBehave
    @Given(": Przechodze do strony glownej Wikipedii")
    public void givenPrzechodzeDoStronyGlownejWikipedii() {
        open("http://en.wikipedia.org/wiki/Main_Page");
    }

    @When(": Wprowadzam wartosc $value w polu o nazwie $fieldName")
    public void whenWprowadzamWartoscTestDrivenDevelopmentWPoluONazwieSearch(String value,
                                        String fieldName){
        $(By.name(fieldName)).setValue(value);
    }

    @When(": Klikam przycisk $buttonName")
    public void whenKlikamPrzyciskGo(String buttonName){
        $(By.name(buttonName)).click();
    }

    @Then(": Tytul strony zawiera czlon $title")
    public void thenTytulStronyZawieraCzlonTestDrivenDevelopment(String title) {
        assertThat(title(), containsString(title));
    }
  */
}
