package com.packtpublishing.tddjava.ch04ship;

public class Ship {

    private final Location location;
    public Location getLocation() {
        return location;
    }

    private Planet planet;
    public Planet getPlanet() {
        return planet;
    }

//    public Ship(Location location) {
//        this.location = location;
//    }
    public Ship(Location location, Planet planet) {
        this.location = location;
        this.planet = planet;
    }

    public boolean moveForward() {
//        return location.forward();
        return location.forward(planet.getMax());
    }

    public boolean moveBackward() {
//        return location.backward();
        return location.backward(planet.getMax());
    }

    public void turnLeft() {
        location.turnLeft();
    }

    public void turnRight() {
        location.turnRight();
    }

    public void receiveCommands(String commands) {
        for (char command : commands.toCharArray()) {
            switch(command) {
                case 'n':
                    moveForward();
                    break;
                case 'w':
                    moveBackward();
                    break;
                case 'l':
                    turnLeft();
                    break;
                case 'p':
                    turnRight();
                    break;
            }
        }
    }

}
