package com.packtpublishing.tddjava.ch02friendships;

import org.testng.Assert;
import org.testng.annotations.*;

import java.util.Arrays;
import java.util.List;

@Test
public class FriendshipsTest {

    Friendships friendships;

    @BeforeClass
    public static void beforeClass() {
        // Ta metoda jest uruchamiana raz w trakcie inicjowania klasy
    }

    @BeforeMethod
    public void before() {
        friendships = new Friendships();
        friendships.makeFriends("Joe", "Audrey");
        friendships.makeFriends("Joe", "Peter");
        friendships.makeFriends("Joe", "Michael");
        friendships.makeFriends("Joe", "Britney");
        friendships.makeFriends("Joe", "Paul");
    }

    @AfterClass
    public static void afterClass() {
        // Ta metoda jest uruchamiana raz po wykonaniu wszystkich testów
    }

    @AfterMethod
    public void after() {
        // Ta metoda jest uruchamiana raz po wykonaniu każdego testu
    }

    public void alexDoesNotHaveFriends() {
        Assert.assertTrue(friendships.getFriendsList("Alex").isEmpty(), "Alex nie ma przyjaciół");
    }

    public void joeHas5Friends() {
        Assert.assertEquals(friendships.getFriendsList("Joe").size(), 5, "Joe ma pięcioro przyjaciół");
    }

    public void joeIsFriendWithEveryone() {
        List<String> friendsOfJoe = Arrays.asList("Audrey", "Peter", "Michael", "Britney", "Paul");
        Assert.assertTrue(friendships.getFriendsList("Joe").containsAll(friendsOfJoe));
    }

}
