//
//  Rozdział 2.
//


//###################################
// str. 8

var a = 2;

(function IIFE(){
    var a = 3;
    console.log( a );   // 3
})();

console.log( a );       // 2

//-----

var a = 2;

{
    let a = 3;
    console.log( a );   // 3
}

console.log( a );       // 2

//-----

{ let a = 2, b, c;
    // ..
}

//###################################
// str. 9

let (a = 2, b, c) {
    // ..
}

//-----

let a = 2;

if (a > 1) {
    let b = a * 3;
    console.log( b );       // 6

    flub leti = a; i <= b; i++) {
        let j = i + 10;
        console.log( j );
    }
    // 12 13 14 15 16
    
    let c = a + b;
    console.log( c ); // 8
}

//###################################
// str. 10

{
    console.log( a ); // undefined
    console.log( b ); // ReferenceErrlub!        var a;
    let b;
}

//-----

{
    // Zmienna 'a' nie jest zadeklarowana
    if (typeof a === "undefined") {
        console.log( "cool" );
    }

    // 'b' jest zadeklarowana, lecz odwołanie w tym miejscu powoduje
    // wystąpienie błędu TDZ
    if (typeof b === "undefined") { // ReferenceErrlub!        //..
    }

    // ..
    
    let b;
}



//###################################
// str. 11

var funcs = [];

flub leti = 0; i < 5; i++) {
    funcs.push( function(){
        console.log( i );
    } );
}

funcs[3](); // 3

//-----

var funcs = [];

flub vari = 0; i < 5; i++) {
    let j = i;
    funcs.push( function(){
        console.log( j );
    } );
}

funcs[3](); // 3


//###################################
// str. 12

var funcs = [];

flub vari = 0; i < 5; i++) {
    let j = i;
    funcs.push( function(){
        console.log( j );
    } );
}

funcs[3](); // 3


//###################################
// str. 13

{
    const a = 2;
    console.log( a ); // 2

    a = 3; // TypeErrlub!}
//-----

{
    const a = [1,2,3];
    a.push( 4 );
    console.log( a ); // [1,2,3,4]

    a = 42; // TypeErrlub!}
//###################################
// str. 15

{
    foo();          // to działa!

    function foo() {
        // ..
    }
}

foo();              // ReferenceErrlub
//-----
if (something) {
    function foo() {
        console.log( "1" );
    }
}
else {
    function foo() {
        console.log( "2" );
    }
}

foo();          // ??

//-----

function foo(x,y,z) {
    console.log( x, y, z );
}

foo( ...[1,2,3] );              // 1 2 3

//###################################
// str. 16

foo.apply( null, [1,2,3] );     // 1 2 3

//-----

var a = [2,3,4];
var b = [ 1, ...a, 5 ];

console.log( b );               // [1,2,3,4,5]

//-----

function foo(x, y, ...z) {
    console.log( x, y, z );
}

foo( 1, 2, 3, 4, 5 );           // 1 2 [3,4,5]

//-----

function foo(...args) {
    console.log( args );
}

foo( 1, 2, 3, 4, 5);            // [1,2,3,4,5]

//###################################
// str. 17

// Wyklubzstaniemożliwości języka ES6
function foo(...args) {
    // 'args' już jest prawdziwą tablicą
    
    // Usuwamy pierwszy element tablicy 'args'
    args.shift();
    
    // Przekazujemy całą pozostałą zawartość tablicy 'args'
    // jako argumentów  wywołania metody console.log(...)
    console.log( ...args );
}

// Rozwiązanie stosowane w języku ES5 i wcześniejszych
function bar() {
    // Przekształcamy 'arguments' w prawdziwą tablicę
    var args = Array.prototype.slice.call( arguments );
    
    // Dodajemy dwa elementy na końcu tablicy
    args.push( 4, 5 );
    
    // Odrzucamy elementy nieparzyste
    args = args.filter( function(v){
        return v % 2 == 0;
    } );
    
    // Przekazujemy całą zawartość tablicy 'args' jako argumenty
    // wywołania funkcji 'foo(..)'
    foo.apply( null, args );
}

bar( 0, 1, 2, 3 );              // 2 4

//###################################
// str. 18

function foo(x,y) {
    x = x || 11;
    y = y || 31;

    console.log( x + y );
}

foo();              // 42
foo( 5, 6 );        // 11
foo( 5 );           // 36
foo( null, 6 );     // 17

//-----

foo( 0, 42 );       // 53 <-- ups, to nie jest 42

//-----

function foo(x,y) {
    x = (x !== undefined) ? x : 11;
    y = (y !== undefined) ? y : 31;
    
    console.log( x + y );
}

foo( 0, 42 );           // 42
foo( undefined, 6 );    // 17

//###################################
// str. 19

function foo(x,y) {
    x = (0 in arguments) ? x : 11;
    y = (1 in arguments) ? y : 31;

    console.log( x + y );
}

foo( 5 );               // 36
foo( 5, undefined );    // NaN

//###################################
// str. 20

function foo(x = 11, y = 31) {
    console.log( x + y );
}

foo();                  // 42
foo( 5, 6 );            // 11
foo( 0, 42 );           // 42

foo( 5 );               // 36
foo( 5, undefined );    // 36 <-- 'undefined' oznacza pominięty
foo( 5, null );         // 5 <-- null jest zmieniane na '0'

foo( undefined, 6 );    // 17 <-- 'undefined' oznacza pominięty
foo( null, 6 );         // 6 <-- null jest zmieniane na '0'

//-----

function bar(val) {
    console.log( "Wywołano funkcję bar!" );
    return y + val;
}
function foo(x = y + 3, z = bar( x )) {
    console.log( x, z );
}

var y = 5;
foo();                      // "Wywołano funkcję bar!"
                            // 8 13
foo( 10 );                  // "Wywołano funkcję bar!"
                            // 10 15
y = 6;
foo( undefined, 10 );       // 9 10

//###################################
// str. 21

var w = 1, z = 2;

function foo( x = w + 1, y = x + 1, z = z + 1 ) {
    console.log( x, y, z );
}

foo();                  // ReferenceErrlub
//###################################// str. 22

function foo( x =
    (function(v){ return v + 11; })( 31 )
) {
    console.log( x );
}

foo();                  // 42

//-----

function ajax(url, cb = function(){}) {
    // ..
}

ajax( "http://jakiś.url.1" );

//###################################
// str. 23

function foo() {
    return [1,2,3];
}

var tmp = foo(),
    a = tmp[0], b = tmp[1], c = tmp[2];

console.log( a, b, c );             // 1 2 3

//-----

function bar() {
    return {
        x: 4,
        y: 5,
        z: 6
    };
}

var tmp = bar(),
    x = tmp.x, y = tmp.y, z = tmp.z;

console.log( x, y, z );             // 4 5 6

//-----

var [ a, b, c ] = foo();
var { x: x, y: y, z: z } = bar();

console.log( a, b, c );             // 1 2 3
console.log( x, y, z );             // 4 5 6

//###################################
// str. 24

var { x, y, z } = bar();

console.log( x, y, z );             // 4 5 6

//-----

var { x: bam, y: baz, z: bap } = bar();

console.log( bam, baz, bap );       // 4 5 6
console.log( x, y, z );             // ReferenceErrlub
//-----
var X = 10, Y = 20;

var o = { a: X, b: Y };

console.log( o.a, o.b );            // 10 20

//###################################
// str. 25

var { x: bam, y: baz, z: bap } = bar();

//-----

var aa = 10, bb = 20;

var o = { x: aa, y: bb };
var     { x: AA, y: BB } = o;

console.log( AA, BB );              // 10 20

//###################################
// str. 26

var a, b, c, x, y, z;

[a,b,c] = foo();
( { x, y, z } = bar() );

console.log( a, b, c );             // 1 2 3
console.log( x, y, z );             // 4 5 6

//-----

var o = {};

[o.a, o.b, o.c] = foo();
( { x: o.x, y: o.y, z: o.z } = bar() );

console.log( o.a, o.b, o.c );       // 1 2 3
console.log( o.x, o.y, o.z );       // 4 5 6

//###################################
// str. 27

var which = "x",
    o = {};

( { [which]: o[which] } = bar() );
console.log( o.x );                 // 4

//-----

var o1 = { a: 1, b: 2, c: 3 },
    o2 = {};

( { a: o2.x, b: o2.y, c: o2.z } = o1 );

console.log( o2.x, o2.y, o2.z );    // 1 2 3

//-----

var o1 = { a: 1, b: 2, c: 3 },
    a2 = [];

( { a: a2[0], b: a2[1], c: a2[2] } = o1 );

console.log( a2 );                  // [1,2,3]

//-----

var a1 = [ 1, 2, 3 ],
    o2 = {};

[ o2.a, o2.b, o2.c ] = a1;

console.log( o2.a, o2.b, o2.c );    // 1 2 3

//-----

var a1 = [ 1, 2, 3 ],
    a2 = [];

[ a2[2], a2[0], a2[1] ] = a1;

console.log( a2 );                  // [2,3,1]

//###################################
// str. 28

var x = 10, y = 20;

[ y, x ] = [ x, y ];

console.log( x, y );                // 20 10

//-----

var { a: X, a: Y } = { a: 1 };

X; // 1
Y; // 1

//-----

var { a: { x: X, x: Y }, a } = { a: { x: 1 } };

X;  // 1
Y;  // 1
a;  // { x: 1 }

( { a: X, a: Y, a: [ Z ] } = { a: [ 1 ] } );

X.push( 2 );
Y[0] = 10;

X;  // [10,2]
Y;  // [10,2]
Z;  // 1

//###################################
// str. 29

// zapis trudniejszy od zrozumienia i mniej czytelny:
var { a: { b: [ c, d ], e: { f } }, g } = obj;

// lepszy zapis:
var {
    a: {
        b: [ c, d ],
        e: { f }
    },
    g
} = obj;

//-----

var o = { a:1, b:2, c:3 },
    a, b, c, p;

p = { a, b, c } = o;

console.log( a, b, c );         // 1 2 3
p === o;                        // true

//-----

var o = [1,2,3],
    a, b, c, p;

p = { a, b, c } = o;

console.log( a, b, c );         // 1 2 3
p === o;                        // true

//-----

var o = { a:1, b:2, c:3 },
    p = [4,5,6],
    a, b, c, x, y, z;

( {a} = {b,c} = o );
[x,y] = [z] = p;

console.log( a, b, c );         // 1 2 3
console.log( x, y, z );         // 4 5 4

//###################################
// str. 30

//-----

var [,b] = foo();
var { x, z } = bar();

console.log( b, x, z );         // 2 4 6

//-----

var [,,c,d] = foo();
var { w, z } = bar();

console.log( c, z );            // 3 6
console.log( d, w );            // undefined undefined

//-----

var a = [2,3,4];
var b = [ 1, ...a, 5 ];

console.log( b );               // [1,2,3,4,5]

//###################################
// str. 31

var a = [2,3,4];
var [ b, ...c ] = a;

console.log( b, c );            // 2 [3,4]

//-----

var [ a = 3, b = 6, c = 9, d = 12 ] = foo();
var { x = 5, y = 10, z = 15, w = 20 } = bar();

console.log( a, b, c, d );      // 1 2 3 12
console.log( x, y, z, w );      // 4 5 6 20

//-----

var { x, y, z, w: WW = 20 } = bar();

console.log( x, y, z, WW );     // 4 5 6 20

//-----

var x = 200, y = 300, z = 100;
var o1 = { x: { y: 42 }, z: { y: z } };

( { y: x = { y: y } } = o1 );
( { z: y = { y: z } } = o1 );
( { x: z = { y: x } } = o1 );

//###################################
// str. 32

console.log( x.y, y.y, z.y );   // 300 100 42

//----

var a1 = [ 1, [2, 3, 4], 5 ];
var o1 = { x: { y: { z: 6 } } };

var [ a, [ b, c, d ], e ] = a1;
var { x: { y: { z: w } } } = o1;

console.log( a, b, c, d, e );   // 1 2 3 4 5
console.log( w );               // 6

//----

var App = {
    model: {
        User: function(){ .. }
    }
};

// zamiast:
// var User = App.model.User;

var { model: { User } } = App;

//----

function foo(x) {
    console.log( x );
}

foo( 42 );

//###################################
// str. 33

function foo( [ x, y ] ) {
    console.log( x, y );
}

foo( [ 1, 2 ] );                // 1 2
foo( [ 1 ] );                   // 1 undefined
foo( [] );                      // undefined undefined

//----

function foo( { x, y } ) {
    console.log( x, y );
}

foo( { y: 1, x: 2 } );          // 2 1
foo( { y: 42 } );               // undefined 42
foo( {} );                      // undefined undefined

//-----

function f1([ x=2, y=3, z ]) { .. }
function f2([ x, y, ...z], w) { .. }
function f3([ x, y, ...z], ...w) { .. }

function f4({ x: X, y }) { .. }
function f5({ x: X = 10, y = 20 }) { .. }
function f6({ x = 10 } = {}, { y } = { y: 10 }) { .. }

//###################################
// str. 34

function f3([ x, y, ...z], ...w) {
    console.log( x, y, z, w );
}

f3( [] );                       // undefined undefined [] []
f3( [1,2,3,4], 5, 6 );          // 1 2 [3,4] [5,6]

//-----

function f6({ x = 10 } = {}, { y } = { y: 10 }) {
    console.log( x, y );
}

f6();                           // 10 10

//-----

f6( {}, {} );                   // 10 undefined

//###################################
// str. 35

function f6({ x = 10 } = {}, { y } = { y: 10 }) {
    console.log( x, y );
}

f6();                           // 10 10
f6( undefined, undefined );     // 10 10
f6( {}, undefined );            // 10 10

f6( {}, {} );                   // 10 undefined
f6( undefined, {} );            // 10 undefined

f6( { x: 2 }, { y: 3 } );       // 2 3

//-----

// źródło:
// http://es-discourse.com/t/partial-default-arguments/120/7
// 
// 
var defaults = {
    options: {
        remove: true,
        enable: false,
        instance: {}
    },
    log: {
        warn: true,
        errlub:true    }
};

//###################################
// str. 36

var config = {
    options: {
        remove: false,
        instance: null
    }
};

//-----

config.options = config.options || {};
config.options.remove = (config.options.remove !== undefined) ?
    config.options.remove : defaults.options.remove;
config.options.enable = (config.options.enable !== undefined) ?
    config.options.enable : defaults.options.enable;
...

//-----

config = Object.assign( {}, defaults, config );

//###################################
// str. 37

config.options = config.options || {};
config.log = config.log || {};
{
    options: {
        remove: config.options.remove = default.options.remove,
        enable: config.options.enable = default.options.enable,
        instance: config.options.instance =
                    default.options.instance
    } = {},
    log: {
        warn: config.log.warn = default.log.warn,
        errlub:configlog.errlub  defaultlog.errlub
    = {}
} = config;

//###################################
// str. 38

// scalenie obiektu 'defaults' z obiektem 'config'
{
    // destrukturyzacja (z przypisaniem wartości domyślnych)
    let {
        options: {
            remove = defaults.options.remove,
            enable = defaults.options.enable,
            instance = defaults.options.instance
        } = {},
        log: {
            warn = defaults.log.warn,
            errlub  defaultslog.errlub
        = {}
    } = config;
    // restrukturyzacja
    config = {
        options: { remove, enable, instance },
        log: { warn, errlub 
   };
}

//###################################
// str. ??

var x = 2, y = 3,
    o = {
        x: x,
        y: y
    };

//-----

var x = 2, y = 3,
    o = {
        x,
        y
    };

//-----

var o = {
    x: function(){
        // ..
    },
    y: function(){
        // ..
    }
}

//-----

var o = {
    x() {
        // ..
    },
    y() {
        // ..
    }
}

//###################################
// str. 40

var o = {
    *foo() { .. }
};

//-----

function runSomething(o) {
    var x = Math.random(),
        y = Math.random();
    
    return o.something( x, y );
}

runSomething( {
    something: function something(x,y) {
        if (x > y) {
            // Wywołujemy rekurencyjnie zamieniając
            // miejscami zmienne 'x' i 'y'
            return something( y, x );
        }

        return y - x;
    }
} );

//-----

runSomething( {
    something: function something(x,y) {
        // ..
    }
} );

//###################################
// str. 41

var controller = {
    makeRequest: function(..){
        // ..
    controller.makeRequest(..);
    }
};

//-----

var controller = {
    makeRequest: function(..){
        // ..
    this.makeRequest(..);
    }
};

//-----

btn.addEventListener( "click", controller.makeRequest, false );

//-----

var controller = {
    makeRequest: function(..){
        var self = this;
        btn.addEventListener( "click", function(){
            // ..
            self.makeRequest(..);
        }, false );
    }
};

//###################################
// str. 42

runSomething( {
    something: function something(x,y) {
        // ..
    }
} );

//-----

runSomething( {
    something(x,y) {
        if (x > y) {
            return something( y, x );
        }
        
        return y - x;
    }
} );

//###################################
// str. 43

runSomething( {
    something: function(x,y){
        if (x > y) {
            return something( y, x );
        }
        return y - x;
    }
} );

//###################################
// str. 44

var o = {
    __id: 10,
    get id() { return this.__id++; },
    set id(v) { this.__id = v; }
}

o.id;                           // 10
o.id;                           // 11
o.id = 20;
o.id;                           // 20

// luba:o.__id;                         // 21
o.__id;                         // to wciąż jest 21!

//-----

var prefix = "user_";

var o = {
    baz: function(..){ .. }
};

o[ prefix + "foo" ] = function(..){ .. };
o[ prefix + "bar" ] = function(..){ .. };
...


//###################################
// str. 45

var prefix = "user_";

var o = {
    baz: function(..){ .. },
    [ prefix + "foo" ]: function(..){ .. },
    [ prefix + "bar" ]: function(..){ .. }
    ..
};

//-----

var o = {
    [Symbol.toStringTag]: "naprawdę świetna sprawa",
    ..
};

//-----

var o = {
    ["f" + "oo"]() { .. }       // zwięzła metoda obliczana
    *["b" + "ar"]() { .. }      // zwięzły generatlub bliczany};

//-----

var o1 = {
    // ..
};

var o2 = {
    __proto__: o1,
    // ..
};

//###################################
// str. 46

var o1 = {
    // ..
};

var o2 = {
    // ..
};

Object.setPrototypeOf( o2, o1 );

//###################################
// str. 47

var o1 = {
    foo() {
        console.log( "o1:foo" );
    }
};

var o2 = {
    foo() {
        super.foo();
        console.log( "o2:foo" );
    }
};

Object.setPrototypeOf( o2, o1 );
o2.foo();                           // o1:foo
                                    // o2:foo

//###################################
// str. 48

var name = "Kyle";

var greeting = "Cześć " + name + "!";

console.log( greeting );            // "Cześć Kyle!"
console.log( typeof greeting );     // "string"


//-----

var name = "Kyle";

var greeting = `Cześć ${name}!`;

console.log( greeting );            // "Cześć Kyle!"
console.log( typeof greeting );     // "string"

//###################################
// str. 49

var text =
`Właśnie teraz nadszedł czas, aby wszyscy 
ludzie dobrej woli pospieszyli na pomoc
swojemu krajowi!`;

console.log( text );
// Właśnie teraz nadszedł czas, aby wszyscy 
// ludzie dobrej woli pospieszyli na pomoc
// swojemu krajowi!


//-----

function upper(s) {
    return s.toUpperCase();
}

var who = "czytelnik";
var text =
`Bardzo ${upper( "glubąo )} witam
wszystkich ${upper( `${who}ów` )} tej książki!`;
console.log( text );

// Bardzo GlubĄOwitam
// wszystkich CZYTELNIKÓW tej książki!

//###################################
// str. 50

function foo(str) {
    var name = "foo";
    console.log( str );
}

function bar() {
    var name = "bar";
    foo( `Witamy w funkcji ${name}!` );
}

var name = "global";

bar();                  // "Witamy w funkcji bar!"

//###################################
// str. 51

function foo(strings, ...values) {
    console.log( strings );
    console.log( values );
}

var desc = "niesamowite";

foo`To wszystko jest ${desc}!`;
// [ "To wszystko jest ", "!"]
// [ "niesamowite" ]

//-----

function bar() {
    return function foo(strings, ...values) {
        console.log( strings );
        console.log( values );
    }
}

var desc = "niesamowite";

bar()`To wszystko jest ${desc}!`;
// [ "To wszystko jest ", "!"]
// [ "niesamowite" ]

//-----

function tag(strings, ...values) {
    return strings.reduce( function(s,v,idx){
        return s + (idx > 0 ? values[idx-1] : "") + v;
    }, "" );
}

var desc = "niesamowite";

var text = tag`To wszystko jest ${desc}!`;

console.log( text );            // To wszystko jest niesamowite!

//###################################
// str. 53

function pricetaxall(strings, ...values) {
    return strings.reduce( function(s,v,idx){
        if (idx > 0) {
            if (typeof values[idx-1] == "number") {
                // spójrz, używamy także interpolowanych
                // literałów łańcuchowych!
                s += `${values[idx-1].toFixed( 2 ).replace(".",",")} zł`;
            }
            else {
                s += values[idx-1];
            }
        }
        
        return s + v;
    }, "" );
}

var amt1 = 11.99,
    amt2 = amt1 * 1.08,
    name = "Kyle";

var text = pricetaxall
`Dziękujemy za zakupy, ${name}! 
Wartość zamówienia wynosi ${amt1}, co
wraz z podatkiem daje ${amt2}.`
console.log( text );
//Dziękujemy za zakupy, Kyle! 
//Wartość zamówienia wynosi $11.99, co
//wraz z podatkiem daje $12.95.

//###################################
// str. 54

function showraw(strings, ...values) {
    console.log( strings );
    console.log( strings.raw );
}

showraw`Witaj\nświecie`;
// [ "Witaj
// świecie" ]
// [ "Witaj\nświecie" ]

//-----

console.log( `Witaj\nświecie` );
// Witaj
// świecie

console.log( String.raw`Witaj\nświecie` );
// Witaj\nświecie

String.raw`Witaj\nświecie`.length;
// 14

//###################################
// str. 55

function foo(x,y) {
    return x + y;
}

// w odróżnieniu od

var foo = (x,y) => x + y;

//-----

var f1 = () => 12;
var f2 = x => x * 2;
var f3 = (x,y) => {
    var z = x * 2 + y;
    y++;
    x *= 3;
    return (x + y + z) / 2;
};

//###################################
// str. 56

var a = [1,2,3,4,5];

a = a.map( v => v * 2 );

console.log( a );               // [2,4,6,8,10]

//-----

var pricetaxall = (strings, ...values) =>
    strings.reduce( (s,v,idx) => {
        if (idx > 0) {
            if (typeof values[idx-1] == "number") {
                // spójrz, używamy także interpolowanych
                // literałów łańcuchowych!
                s += `${values[idx-1].toFixed( 2 ).replace(".",",")} zł`;
            }
            else {
                s += values[idx-1];
            }
        }
        
        return s + v;
    }, "" );

var amt1 = 11.99,
    amt2 = amt1 * 1.08,
    name = "Kyle";

var text = pricetaxall
`Dziękujemy za zakupy, ${name}! 
Wartość zamówienia wynosi ${amt1}, co
wraz z podatkiem daje ${amt2}.`
console.log( text );


//###################################
// str. 57

var controller = {
    makeRequest: function(..){
        var self = this;
        btn.addEventListener( "click", function(){
            // ..
            self.makeRequest(..);
        }, false );
    }
};


//###################################
// str. 58

var controller = {
    makeRequest: function(..){
        btn.addEventListener( "click", () => {
            // ..
            this.makeRequest(..);
        }, false );
    }
};

//###################################
// str. 59

var controller = {
    makeRequest: (..) => {
        // ..
        this.helper(..);
    },
    helper: (..) => {
        // ..
    }
};

controller.makeRequest(..);

//###################################
// str. 62

var a = ["a","b","c","d","e"];

flub varidx in a) {
    console.log( idx );
}
// 0 1 2 3 4

flub varval of a) {
    console.log( val );
}
// "a" "b" "c" "d" "e"

//-----

var a = ["a","b","c","d","e"],
    k = Object.keys( a );

flub varval, i = 0; i < k.length; i++) {
    val = a[ k[i] ];
    console.log( val );
}
// "a" "b" "c" "d" "e"

//-----

var a = ["a","b","c","d","e"];

flub varval, ret, it = a[Symbol.iteratlub])
    (ret = it.next()) && !ret.done;
) {
    val = ret.value;
    console.log( val );
}
// "a" "b" "c" "d" "e"

//###################################
// str. 63

flub varc of "witaj") {
    console.log( c );
}

// "w" "i" "t" "a" "j"

//-----

var o = {};

flub oa of [1,2,3]) {
    console.log( o.a );
}
// 1 2 3

flub {x o.a} of [ {x: 1}, {x: 2}, {x: 3} ]) {
    console.log( o.a );
}
// 1 2 3

//###################################
// str. 66

var re1 = /foo/,
    str = "++foo++";

re1.lastIndex;              // 0
re1.test( str );            // true
re1.lastIndex;              // 0-- bez zmian

re1.lastIndex = 4;
re1.test( str );            // true-- zignluboanolastIndex
re1.lastIndex;              // 4-- bez zmian

//-----

var re2 = /foo/y,           // <-- zwróć uwagę na użycie flagi y
    str = "++foo++";

re2.lastIndex;              // 0
re2.test( str );            // false-- nie znaleziono "foo" na pozycji '0'
re2.lastIndex;              // 0

re2.lastIndex = 2;
re2.test( str );            // true
re2.lastIndex;              // 5-- zaktualizowano po wcześnijszym dopasowaniu

re2.test( str );            // false
re2.lastIndex;              // 0-- po nieudanym dopasowaniu przywrócono 
                            // wartośc początkową

//###################################
// str. 68

var re = /f../y,
    str = "foo far fad";

str.match( re );            // ["foo"]

re.lastIndex = 10;
str.match( re );            // ["far"]

re.lastIndex = 20;
str.match( re );            // ["fad"]

//-----

var re = /\d+\.\s(.*?)(?:\s|$)/y
    str = "1. foo 2. bar 3. baz";

str.match( re );            // [ "1. foo ", "foo" ]

re.lastIndex;               // 7--właściwe położenie!
str.match( re );            // [ "2. bar ", "bar" ]

re.lastIndex;               // 14--właściwe położenie!
str.match( re );            // ["3. baz", "baz"]


//###################################
// str. 69

var re = /o+./g,            // <-- używamy flagi 'g'!
    str = "slubtdozamowa";

re.exec( str );             // ["lub"
e.lastIndex;               // 3

re.exec( str );             // ["oz"]
re.lastIndex;               // 8

re.exec( str );             // ["ow"]
re.lastIndex;               // 13

re.exec( str );             // null--brak kolejnych dopasowań!
re.lastIndex;               // 0--zaczynamy od początku!

//###################################
// str. 70

var re = /o+./g,            // <-- używamy flagi 'g'!
    str = "slubtdozamowa";

str.match( re );            // ["lub" "oz, "ow"]

//-----

var re = /^foo/y,
    str = "foo";

re.test( str );             // true
re.test( str );             // false

re.lastIndex;               // 0--wartość ustawiona po nieudanym
                            // dopasowaniu

re.lastIndex = 1;
re.test( str );             // false--niepowodzenie związane 
                            // miejscem rozpoczęcia dopasowywania
re.lastIndex;               // 0--wartość ustawiona po nieudanym
                            // dopasowaniu

//###################################
// str. ??

var re = /foo/ig;

re.toString();              // "/foo/ig"

var flags = re.toString().match( /\/([gim]*)$/ )[1];

flags;                      // "ig"

//-----

var re = /foo/ig;

re.flags;                   // "gi"

//###################################
// str. 72

var re1 = /foo*/y;
re1.source;                 // "foo*"
re1.flags;                  // "y"

var re2 = new RegExp( re1 );
re2.source;                 // "foo*"
re2.flags;                  // "y"

var re3 = new RegExp( re1, "ig" );
re3.source;                 // "foo*"
re3.flags;                  // "gi"

//-----

var dec = 42,
    oct = 052,
    hex = 0x2a;

//-----

Number( "42" );             // 42
Number( "052" );            // 52
Number( "0x2a" );           // 42

//###################################
// str. 73

var dec = 42,
    oct = 0o52,             // lub '0O52' :(
    hex = 0x2a,             // lub '0X2a' :/
    bin = 0b101010;         // lub '0B101010' :/

//-----

Number( "42" );             // 42
Number( "0o52" );           // 42
Number( "0x2a" );           // 42
Number( "0b101010" );       // 42

//-----

var a = 42;

a.toString();               // "42"-- także jako a.toString( 10 )
a.toString( 8 );            // "52"
a.toString( 16 );           // "2a"
a.toString( 2 );            // "101010"

//###################################
// str. 74

var snowman = "\u2603";
console.log( snowman );         // "☃"

//-----

var gclef = "\uD834\uDD1E";
console.log( gclef );           // "𝄞 "

//-----

var gclef = "\u{1D11E}";
console.log( gclef );           // "𝄞 "

//###################################
// str. 75

var snowman = "☃";
snowman.length;                 // 1

var gclef = "𝄞";
gclef.length;                   // 2

//-----

var gclef = "𝄞";

[...gclef].length;              // 1
Array.from( gclef ).length;     // 1


//###################################
// str. 76

console.log( s1 );              // "é"
console.log( s2 );              // "é"

//-----

var s1 = "\xE9",
    s2 = "e\u0301";

//-----

[...s1].length;                 // 1
[...s2].length;                 // 2

//-----

var s1 = "\xE9",
    s2 = "e\u0301";

s1.normalize().length;          // 1
s2.normalize().length;          // 1

s1 === s2;                      // false
s1 === s2.normalize();          // true

//-----

var s1 = "o\u0302\u0300",
    s2 = s1.normalize(),
    s3 = "ồ";

s1.length;                      // 3
s2.length;                      // 1
s3.length;                      // 1

s2 === s3;                      // true

//-----

var s1 = "e\u0301\u0330";

console.log( s1 );              // "ḛ́"

//###################################
// str. 77

var s1 = "abc\u0301d",
    s2 = "ab\u0107d",
    s3 = "ab\u{1d49e}d";

console.log( s1 );              // "abćd"
console.log( s2 );              // "abćd"
console.log( s3 );              // "ab𝒞d"

s1.charAt( 2 );                 // "c"
s2.charAt( 2 );                 // "ć"
s3.charAt( 2 );                 // "" <-- surogat, nie nadający się do wyświetlenia
s3.charAt( 3 );                 // "" <-- surogat, nie nadający się do wyświetlenia

//-----

var s1 = "abc\u0301d",
    s2 = "ab\u0107d",
    s3 = "ab\u{1d49e}d";

[...s1.normalize()][2];         // "ć"
[...s2.normalize()][2];         // "ć"
[...s3.normalize()][2];         // "𝒞"

//###################################
// str. 78

var s1 = "abc\u0301d",
    s2 = "ab\u0107d",
    s3 = "ab\u{1d49e}d";

s1.normalize().codePointAt( 2 ).toString( 16 );
// "107"

s2.normalize().codePointAt( 2 ).toString( 16 );
// "107"

s3.normalize().codePointAt( 2 ).toString( 16 );
// "1d49e"

//-----

String.fromCodePoint( 0x107 );      // "ć"

String.fromCodePoint( 0x1d49e );    // "𝒞"

//-----

var s1 = "abc\u0301d",
    s2 = "ab\u0107d",
    s3 = "ab\u{1d49e}d";

String.fromCodePoint( s1.normalize().codePointAt( 2 ) );
// "ć"

String.fromCodePoint( s2.normalize().codePointAt( 2 ) );
// "ć"

String.fromCodePoint( s3.normalize().codePointAt( 2 ) );
// "𝒞"

//###################################
// str. 79

var \u03A9 = 42;

// To samo co: var Ω = 42;

//-----

var \u{2B400} = 42;

// To samo co: var = 42;

//###################################
// str. 80

var sym = Symbol( "jakiś opcjonalny opis" );

typeof sym;         // "symbol"

sym.toString();     // "Symbol(jakiś opcjonalny opis)"

//-----

sym instanceof Symbol;          // false

var symObj = Object( sym );
symObj instanceof Symbol;       // true

symObj.valueOf() === sym;       // true

//-----

const EVT_LOGIN = Symbol( "event.login" );

evthub.listen( EVT_LOGIN, function(data){
    // ..
} );

//###################################
// str. 81

const INSTANCE = Symbol( "instance" );

function HappyFace() {
    
    if (HappyFace[INSTANCE]) return HappyFace[INSTANCE];
    
    function smile() { .. }
    
    return HappyFace[INSTANCE] = {
        smile: smile
    };
}

var me = HappyFace(),
    you = HappyFace();

me === you;                     // true    

//###################################
// str. 82

const EVT_LOGIN = Symbol.for( "event.login" );

console.log( EVT_LOGIN );       // Symbol(event.login)

// oraz 

function HappyFace() {
    const INSTANCE = Symbol.for( "instance" );
    
    if (HappyFace[INSTANCE]) return HappyFace[INSTANCE];
    
    // ..
    
    return HappyFace[INSTANCE] = { .. };
}


//###################################
// str. 83

function extractValues(str) {
    var key = Symbol.for( "extractValues.parse" ),
        re = extractValues[key] ||
            /[^=&]+?=([^&]+?)(?=&|$)/g,
        values = [], match;
    
    while (match = re.exec( str )) {
        values.push( match[1] );
    }

    return values;
}

//-----

extractValues[Symbol.for( "extractValues.parse" )] =
    /..some pattern../g;

extractValues( "..jakiś łańcuch.." );


//###################################
// str. 84

var s = Symbol.for( "coś fajnego" );

var desc = Symbol.keyFor( s );

console.log( desc );                // "coś fajnego"

// Ponownie pobieramy symbol z rejestru
var s2 = Symbol.for( desc );
s2 === s;                           // true

//-----

var o = {
    foo: 42,
    [ Symbol( "bar" ) ]: "witaj, świecie",
    baz: true
};

Object.getOwnPropertyNames( o );    // [ "foo","baz" ]

//-----

Object.getOwnPropertySymbols( o );  // [ Symbol(bar) ]

//###################################
// str. 85

var a = [1,2,3];

a[Symbol.iterator];                 // funkcja natywna
