//
//  Rozdział 5.
//


//###################################
// str. 160

var buf = new ArrayBuffer( 32 );
buf.byteLength;                         // 32

//-----

var arr = new Uint16Array( buf );
arr.length;                             // 16

//###################################
// str. 161

var littleEndian = (function() {
    var buffer = new ArrayBuffer( 2 );
    new DataView( buffer ).setInt16( 0, 256, true );
    return new Int16Array( buffer )[0] === 256;
})();

//###################################
// str. 162

var buf = new ArrayBuffer( 2 );

var view8 = new Uint8Array( buf );
var view16 = new Uint16Array( buf );

view16[0] = 3085;
view8[0];                       // 13
view8[1];                       // 12

view8[0].toString( 16 );        // "d"
view8[1].toString( 16 );        // "c"

// zamiana (jakby zmiana kolejności zapisu!)
var tmp = view8[0];
view8[0] = view8[1];
view8[1] = tmp;

view16[0];                      // 3340

//###################################
// str. 163

var first = new Uint16Array( buf, 0, 2 )[0],
    second = new Uint8Array( buf, 2, 1 )[0],
    third = new Uint8Array( buf, 3, 1 )[0],
    fourth = new Float32Array( buf, 4, 4 )[0];

//###################################
// str. 164

var a = new Int32Array( 3 );
a[0] = 10;
a[1] = 20;
a[2] = 30;

a.map( function(v){
    console.log( v );
} );
// 10 20 30

a.join( "-" );
// "10-20-30"


//-----

var a = new Uint8Array( 3 );
a[0] = 10;
a[1] = 20;
a[2] = 30;

var b = a.map( function(v){
    return v * v;
} );

b;                  // [100, 144, 132]

//-----

var a = new Uint8Array( 3 );
a[0] = 10;
a[1] = 20;
a[2] = 30;

var b = Uint16Array.from( a, function(v){
    return v * v;
} );

b;                  // [100, 400, 900]

//###################################
// str. 165

var a = [ 10, 1, 2, ];
a.sort();                               // [1,10,2]

var b = new Uint8Array( [ 10, 1, 2 ] );
b.sort();                               // [1,2,10] 

//-----
 
var m = {};

var x = { id: 1 },
    y = { id: 2 };

m[x] = "foo";
m[y] = "bar";

m[x];                               // "bar"
m[y];                               // "bar"
 
//###################################
// str. 166

var keys = [], vals = [];

var x = { id: 1 },
    y = { id: 2 };

keys.push( x );
vals.push( "foo" );

keys.push( y );
vals.push( "bar" );

keys[0] === x;                      // true
vals[0];                            // "foo"

keys[1] === y;                      // true
vals[1];                            // "bar"

//-----

var m = new Map();

var x = { id: 1 },
    y = { id: 2 };

m.set( x, "foo" );
m.set( y, "bar" );

m.get( x );                         // "foo"
m.get( y );                         // "bar"

//-----

m.set( x, "foo" );
m.set( y, "bar" );

m.delete( y );

//###################################
// str. 167

m.set( x, "foo" );
m.set( y, "bar" );
m.size;                             // 2

m.clear();
m.size;                             // 0

//-----

var m2 = new Map( m.entries() );

// ma ten sam efekt co:
var m2 = new Map( m );

//-----

var x = { id: 1 },
    y = { id: 2 };

var m = new Map( [
    [ x, "foo" ],
    [ y, "bar" ]
] );

m.get( x );                         // "foo"
m.get( y );                         // "bar"

//-----

var m = new Map();

var x = { id: 1 },
    y = { id: 2 };

m.set( x, "foo" );
m.set( y, "bar" );

var vals = [ ...m.values() ];

vals;                               // ["foo","bar"]
Array.from( m.values() );           // ["foo","bar"]

//###################################
// str. 168

var m = new Map();

var x = { id: 1 },
    y = { id: 2 };

m.set( x, "foo" );
m.set( y, "bar" );

var vals = [ ...m.entries() ];

vals[0][0] === x;                   // true
vals[0][1];                         // "foo"

vals[1][0] === y;                   // true
vals[1][1];                         // "bar"

//-----

var m = new Map();

var x = { id: 1 },
    y = { id: 2 };

m.set( x, "foo" );
m.set( y, "bar" );

var keys = [ ...m.keys() ];

keys[0] === x;                      // true
keys[1] === y;                      // true


//###################################
// str. 169

var m = new Map();

var x = { id: 1 },
    y = { id: 2 };

m.set( x, "foo" );

m.has( x );                         // true
m.has( y );                         // false

