// nieco zmodyfikowana wersja oficjalnego wzorca regularnego adresu e-mail ze specyfikacji W3C HTML5:
// https://html.spec.whatwg.org/multipage/forms.html#valid-e-mail-address
const VALID_EMAIL_REGEX = new RegExp('^[a-zA-Z0-9.!#$%&\'*+\/=?^_`{|}~-]+@' +
  '[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?' +
  '(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+$')

// fałszywy interfejs "rejestracji w newsletterze"
class NewsletterSignup {
  constructor({ name, email }) {
    this.name = name
    this.email = email
  }
  async save() {
    // here's where we would do the work of saving to a database
    // since this method is async, it will return a promise, and
    // since we're not throwing any errors, the promise will
    // resolve successfully
  }
}

exports.home = (req, res) => res.render('home')

exports.newsletterSignup = (req, res) => {
  // w dalszej części książki dowiemy się, czym jest CSRF...na razie
  // podamy zmyśloną wartość
  res.render('newsletter-signup', { csrf: 'miejsce na token CSRF' })
}
exports.newsletterSignupProcess = (req, res) => {
  const name = req.body.name || '', email = req.body.email || ''
  // walidacja danych wejściowych
  if(!VALID_EMAIL_REGEX.test(email)) {
    req.session.flash = {
      type: 'danger',
      intro: 'Validation error!',
      message: 'The email address you entered was not valid.',
    }
    return res.redirect(303, '/newsletter-signup')
  }
  // NewsletterSignup jest przykładowym obiektem jaki można utworzyć; ponieważ
  // każda implementacja może być różna, to do nas należy definicja tych
  // interfejsów specyficznych dla projektu. Ten przykład pokazuje jedynie jak może
  // wyglądać typowa implementacja Express w naszym projekcie
  new NewsletterSignup({ name, email }).save()
    .then(() => {
      req.session.flash = {
        type: 'success',
        intro: 'Thank you!',
        message: 'You have now been signed up for the newsletter.',
      }
      return res.redirect(303, '/newsletter-archive')
    })
    .catch(err => {
      req.session.flash = {
        type: 'danger',
        intro: 'Database error!',
        message: 'There was a database error; please try again later.',
      }
      return res.redirect(303, '/newsletter-archive')
    })
}
exports.newsletterSignupThankYou = (req, res) => res.render('newsletter-signup-thank-you')
exports.newsletterArchive = (req, res) => res.render('newsletter-archive')

exports.notFound = (req, res) => res.render('404')

// Express rozpoznaje funkcję obsługi zdarzeń na podstawie czterech argumentów
// a zatem musimy wyłączyć regułę ESLint no-unused-vars
/* eslint-disable no-unused-vars */
exports.serverError = (err, req, res, next) => res.render('500')
/* eslint-enable no-unused-vars */
