const express = require('express')
const expressHandlebars = require('express-handlebars')
const bodyParser = require('body-parser')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// poniższy wiersz jest niezbędny, aby przetwarzać dane z formularza
app.use(bodyParser.urlencoded({ extended: false }))
app.use(bodyParser.json())

app.get('/thank-you', (req, res) => res.render('11-thank-you'))
app.get('/contact-error', (req, res) => res.render('11-contact-error'))

// kod tego widoku znajduje się w pliku views/10-home.hbs
app.get('*', (req, res) => res.render('11-home'))

app.post('/process-contact', (req, res) => {
  try {
    // zwykle w tym miejscu chcemy zapisać kontakt w bazie danych lub
    // za pomocą innego mechanizmu gwarantującego trwałość... Na razie symulujemy błąd
    if(req.body.simulateError) throw new Error("Błąd zapisania kontaktu!")
    console.log(`contact from ${req.body.name} <${req.body.email}>`)
    res.format({
      'text/html': () => res.redirect(303, '/thank-you'),
      'application/json': () => res.json({ success: true }),
    })
  } catch(err) {
    // w tym miejscu obsługujemy błędy zapisu
    console.error(`błąd przetwarzania kontaktu od ${req.body.name} ` +
      `<${req.body.email}>`)
    res.format({
      'text/html': () =>  res.redirect(303, '/contact-error'),
      'application/json': () => res.status(500).json({
        error: 'błąd zapisania informacji kontaktowych' }),
    })
  }
})

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}\n`))
