# Przykłady z rozdziału 3. - Tworzenie aplikacji internetowych z użyciem Node i Express, Wydanie II

## Witryna WWW dla Meadowlark Travel

W tych przykładach tworzymy podstawową platformę, na podstawie której powstanie witryna Meadowlark Travel z wykorzystaniem technologii Express oraz szablonów Handlebars.

### Konfiguracja

Wszystkie przykłady w tym rozdziale zawierają zależności od modułów Node (`express` i `express-handlebars`).  Te zależności są uwzględnione w pliku _package.json_.  Jednak po pobraniu tego kodu nie będą zainstalowane (_package.json_ jest tylko plikiem manifestu).  Aby je zainstalować, należy wykonać poniższe polecenie:

```
npm install
```

### Przykład 0

Minimalny przykład; wykorzystuje Express, lecz ma ograniczone działanie.  Uruchamianie:

```
node 00-meadowlark
```

Następnie otwórz adres _http://localhost:3000_ w przeglądrce.

### Przykład 1

Ten przykład dodaje podstawowe trasowanie do strony głównej i "O nas".  Uruchamianie:

```
node 01-meadowlark
```

Następnie wypróbuj poniższe adresy:

* _http://localhost:3000_
* _http://localhost:3000/about_
* _http://localhost:3000/nope_

### Przykład 2

Ten przykład korzysta z szablonów Handlebars (_views/*.handlebars_) oraz pliku układu (_views/layouts/main.handlebars_), a także modułu `express.static`, do zwracania plików statycznych (takich jak obrazy) z katalogu _public_.  Uruchamianie:

```
node 02-meadowlark
```

Następnie wypróbuj poniższe adresy:

* _http://localhost:3000_
* _http://localhost:3000/about_
* _http://localhost:3000/nope_

### Przykład 3

Ten przykład (nie opisany w książce, lecz dotyczący rozdziału "Dynamiczne treści w widokach") prezentuje bardzo prosty przykład "ciasteczka szczęścia" na stronie "O nas" (patrz _03-meadowlark.js_ i _views/about.handlebars_).  Uruchamianie:

```
node 03-meadowlark
```

Następnie wypróbuj poniższe adresy:

* _http://localhost:3000_
* _http://localhost:3000/about_
* _http://localhost:3000/nope_
